# NuxSaaS - ISP Management Platform

NuxSaaS is a comprehensive ISP management platform with automated subdomain creation capabilities, designed to streamline ISP operations and enhance customer management.

## Features

- **Automated Account Management**: Streamline customer account creation, suspension, and renewal
- **Subdomain Creation**: Automatically create and manage subdomains for customers
- **Billing Integration**: Connect with PhpNuxBill for comprehensive billing management
- **Email & SMS Notifications**: Automated notifications for all account activities
- **Easy Configuration**: Web-based configuration interface
- **Secure & Reliable**: Built with security best practices

## System Requirements

### Server Requirements
- PHP 7.4 or higher
- MySQL 5.7 or higher  
- Apache/Nginx web server
- SSL certificate (recommended)

### PHP Extensions
- mysqli (MySQL support)
- curl (HTTP requests)
- json (JSON processing)
- mbstring (String functions)
- openssl (SSL support)
- zip (Archive support)

## Installation

### Quick Start

1. **Welcome & System Check**
   - Visit your domain to see the welcome page
   - Click "Check System Requirements" to verify compatibility
   - Resolve any issues before proceeding

2. **Run Installation**
   - Click "Start Installation" from the welcome page
   - Follow the guided installation process
   - Configure database and basic settings

3. **Post-Installation Setup**
   - Configure email/SMS settings
   - Set up billing integration
   - Customize suspension pages

### Manual Installation

1. **Download & Extract**
   ```bash
   # Clone or download the repository
   git clone https://github.com/alvin-kiveu/NuxSaas.git
   cd NuxSaas
   ```

2. **Install Dependencies**
   ```bash
   composer install
   ```
3. **Set Permissions**
   ```bash
   chmod 755 app/views system/cache
   chmod 644 config.php
   ```

4. **Database Setup**
   - Create a MySQL database
   - Import `system/phpnuxbill.sql`
   - Configure database settings in the installation wizard

## Configuration

### Environment Setup
The system automatically detects and configures the environment during installation.

### Database Configuration
Database settings are configured through the web installation wizard or by manually editing the `config.php` file.

### File Permissions
Ensure the web server has proper read/write permissions:
- `app/views/` - Read access
- `system/cache/` - Read/write access  

## Troubleshooting

### Common Issues

**PHP Version Issues**
- Contact hosting provider to upgrade PHP
- For local development, use XAMPP/WAMP with PHP 7.4+

**Missing PHP Extensions**
- Ubuntu/Debian: `sudo apt-get install php-extension-name`
- CentOS/RHEL: `sudo yum install php-extension-name`
- Windows/XAMPP: Enable in php.ini file

**Permission Issues**
- Linux: `chmod 755 directories && chmod 644 files`
- Ensure web server can read/write required directories

**Database Connection Issues**
- Verify database credentials
- Check database server is running
- Ensure MySQL user has proper privileges

### Getting Help

1. Check the system requirements page for detailed diagnostics
2. Review server error logs
3. Ensure all dependencies are properly installed
4. Contact support if issues persist

## License

This project is licensed under the MIT License - see the LICENSE file for details.

## Support

For support and documentation, visit the project repository or contact the development team.

## Contributing

Contributions are welcome! Please read the contributing guidelines before submitting pull requests.

