<?php

namespace App\Controllers;

use Core\Request;
use Core\Redirect;
use Core\DB;

include realpath(dirname(__DIR__) . '/include/function.php');

class SmsSettings {


    public function saveSmsSettings() {
        if (!isset($_POST['save_sms_settings'])) {
            return;
        }

         // Get database connection
         $db = new DB();
         $conn = $db->getConnection();

        $sms_settings = ['sms_api_url' => Request::getPost('sms_api_url', 'string')];
        if (empty($sms_settings['sms_api_url'])) {
            Redirect::redirectError('sms_settings', "SMS API URL is required.");
            return;
        }

        $stmt = $conn->prepare("INSERT INTO settings (setting_name, setting_value) VALUES (?, ?) 
                                        ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)");
        if (!$stmt) {
            Redirect::redirectError('sms_settings', "Failed to prepare statement: " .  $conn->error);
        }

        foreach ($sms_settings as $setting_name => $setting_value) {
            $stmt->bind_param("ss", $setting_name, $setting_value);
            if (!$stmt->execute()) {
                Redirect::redirectError('sms_settings', "Failed to execute statement: " . $stmt->error);
            }
        }

        $stmt->close();
        $conn->close();
       
        $message = "SMS settings have been updated successfully.";
        Redirect::redirectSuccess('sms_settings', $message);
    }

    public function testSmsSettings() {
        if (!isset($_POST['test_sms_settings'])) {
            return;
        }

        $test_number = Request::getPost('test_number', 'string');
        if (empty($test_number)) {
            Redirect::redirectError('sms_settings', "Test phone number is required.");
            return;
        }
        $test_message = "This is a test SMS from your SMS settings page. If you received this message, your SMS settings are working correctly.";
        
        // Get API URL from the database
        $api_url = $this->getSetting('sms_api_url');

        if (empty($api_url)) {
            Redirect::redirectError('sms_settings', "SMS API URL is not set in the database.");
            return;
        }

        $response = sendSMS($api_url, $test_number, $test_message);
        if ($response) {
            Redirect::redirectSuccess('sms_settings', $response);
        } else {
            Redirect::redirectError('sms_settings', "Failed to send test SMS. Please check your settings.");
        }
    }

    private function getSetting($setting_name) {
        // Get database connection
        $db = new DB();
        $conn = $db->getConnection();
        if (!$conn) {
            Redirect::redirectError('sms_settings', "Failed to connect to the database: " . $conn->error);
            return null;
        }
        $stmt = $conn->prepare("SELECT setting_value FROM settings WHERE setting_name = ?");
        $stmt->bind_param("s", $setting_name);
        $stmt->execute();
        $setting_value = null; // Declare the variable before binding
        $stmt->bind_result($setting_value);
        $stmt->fetch();
        $stmt->close();
        return $setting_value;
    }

   
}
