<?php

namespace App\Controllers;

use Core\Request;
use Core\Redirect;
use Core\DB;

class SuspensionPage
{

    public function saveSuspensionPage()
    {
        // Allow CORS for AJAX requests
        header("Access-Control-Allow-Origin: *");
        header("Access-Control-Allow-Methods: POST");
        header("Access-Control-Allow-Headers: Content-Type");

        // Read input data
        $data = json_decode(file_get_contents("php://input"), true);

        // Validate input
        if (!$data || !isset($data['content'])) {
            echo json_encode(['status' => 'error', 'message' => 'Invalid request']);
            exit;
        }

        // Decode HTML entities to restore original content
        $decoded_content = html_entity_decode($data['content'], ENT_QUOTES, 'UTF-8');

        // Define the file path
        $suspend_file = dirname(__DIR__) . '/include/suspend.html';

        // Attempt to write to the file
        if (file_put_contents($suspend_file, $decoded_content) === false) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Failed to update the suspension page! PATH: ' . $suspend_file
            ]);
            exit;
        }

        // Return success response
        echo json_encode([
            'status' => 'success',
            'message' => 'Suspension page updated successfully!'
        ]);
        exit;
    }
}
