<?php
/**
 * Authentication Header for login pages
 * This header is used for login/registration pages
 */

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Set up basic constants if not already defined
if (!defined('BASE_URL')) {
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
    $host = $_SERVER['HTTP_HOST'];
    $scriptPath = str_replace(basename($_SERVER['SCRIPT_NAME']), "", $_SERVER['SCRIPT_NAME']);
    define('BASE_URL', $protocol . $host . $scriptPath);
    define('BASE_RESOURCES_URL', BASE_URL . 'public/');
    
}

// Check if the user is already logged in (only redirect if on login page)
$current_route = $_GET['app_route'] ?? '';
if ($current_route === 'login' && isset($_SESSION['user'])) {
    header('Location: ?app_route=dashboard');
    exit;
}
?>


<!doctype html>
<html lang="en">

<head>

    <meta charset="utf-8" />
    <title><?= COMPANY_NAME ?> - Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta data-react-helmet="true" name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no, viewport-fit=cover">
    </meta>
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <meta content="Premium Multipurpose Admin & Dashboard Template" name="description" />
    <meta content="Themesbrand" name="author" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="<?= BASE_RESOURCES_URL ?>assets/images/favicon.ico">

    <!-- Bootstrap Css -->
    <link href="<?= BASE_RESOURCES_URL ?>assets/css/bootstrap.min.css" id="bootstrap-style" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="<?= BASE_RESOURCES_URL ?>assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="<?= BASE_RESOURCES_URL ?>assets/css/app.min.css" id="app-style" rel="stylesheet" type="text/css" />
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

</head>

<body>

    <?php
    foreach (['error' => 'error', 'success' => 'success'] as $key => $icon) {
        if (isset($_SESSION[$key])) {
            echo "<script>
            document.addEventListener('DOMContentLoaded', function() {
                Swal.fire({
                    icon: '$icon',
                    title: '" . ucfirst($key) . "!',
                    text: '" . addslashes($_SESSION[$key]) . "',
                    confirmButtonColor: '" . ($key === 'error' ? '#d33' : '#3085d6') . "'
                });
            });
        </script>";
            unset($_SESSION[$key]);
        }
    }
    ?>