<?php
/**
 * Installation Header
 * Safe header for installation and setup pages
 */

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Set up basic constants if not already defined
if (!defined('BASE_URL')) {
    $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
    $host = $_SERVER['HTTP_HOST'];
    $scriptPath = str_replace(basename($_SERVER['SCRIPT_NAME']), "", $_SERVER['SCRIPT_NAME']);
    define('BASE_URL', $protocol . $host . $scriptPath);
    define('BASE_RESOURCES_URL', BASE_URL . 'public/');
}

// Include safe database helper
require_once __DIR__ . '/db_safe.php';

// Get database connection if available (don't force it)
$conn = getSafeDbConnection();
?>
<!doctype html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <title>NuxSaas - Installation</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="NuxSaas Installation" name="description" />
    <meta content="NuxSaas" name="author" />
    <!-- App favicon -->
    <link rel="shortcut icon" href="<?= BASE_RESOURCES_URL ?>assets/images/favicon.ico">

    <!-- Bootstrap Css -->
    <link href="<?= BASE_RESOURCES_URL ?>assets/css/bootstrap.min.css" id="bootstrap-style" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="<?= BASE_RESOURCES_URL ?>assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="<?= BASE_RESOURCES_URL ?>assets/css/app.min.css" id="app-style" rel="stylesheet" type="text/css" />
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>

<body class="auth-body-bg">
    <div class="bg-overlay"></div>
    <div class="wrapper-page">
        <div class="container-fluid p-0">
