<?php
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? "https://" : "http://";
$host = $_SERVER['HTTP_HOST'];
$scriptPath = str_replace(basename($_SERVER['SCRIPT_NAME']), "", $_SERVER['SCRIPT_NAME']);
define('BASE_URL', $protocol . $host . $scriptPath);
define('BASE_RESOURCES_URL', BASE_URL . 'public/');

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8" />
    <title>NuxSaaS - ISP Management Platform</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="NuxSaaS ISP Management and Subdomain Creation Platform" name="description" />
    <meta content="Alvin Kiveu" name="author" />
    
    <!-- App favicon -->
    <link rel="shortcut icon" href="<?= BASE_RESOURCES_URL ?>assets/images/favicon.ico">
    
    <!-- Bootstrap Css -->
    <link href="<?= BASE_RESOURCES_URL ?>assets/css/bootstrap.min.css" id="bootstrap-style" rel="stylesheet" type="text/css" />
    <!-- Icons Css -->
    <link href="<?= BASE_RESOURCES_URL ?>assets/css/icons.min.css" rel="stylesheet" type="text/css" />
    <!-- App Css-->
    <link href="<?= BASE_RESOURCES_URL ?>assets/css/app.min.css" id="app-style" rel="stylesheet" type="text/css" />
    
    <style>
        .welcome-gradient {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .feature-icon {
            width: 80px;
            height: 80px;
            background: rgba(255,255,255,0.1);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1rem;
        }
        .step-number {
            width: 60px;
            height: 60px;
            background: #007bff;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            font-size: 1.5rem;
            margin: 0 auto 1rem;
        }
    </style>
</head>

<body data-sidebar="dark">
    <!-- Navigation Bar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <div class="container">
            <a class="navbar-brand" href="?page=onboarding">
                <i class="mdi mdi-rocket-launch-outline"></i>
                NuxSaaS
            </a>
            
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="?page=onboarding">
                            <i class="mdi mdi-home"></i> Setup Guide
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="?page=dependency_check">
                            <i class="mdi mdi-shield-check"></i> Requirements
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="?page=install">
                            <i class="mdi mdi-download"></i> Install
                        </a>
                    </li>
                </ul>
                
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="nav-link" href="?app_route=login">
                            <i class="mdi mdi-login"></i> Login
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>
    
    <div id="layout-wrapper">
