<?php
$basePath = 'app/views/';

$router->addRoute('', $basePath .'onboarding.php', 'GET');
$router->addRoute('login', $basePath .'index.php', 'GET');
$router->addRoute('logout', null, 'GET', 'Auth@logout');

// Pre-installation pages
$router->addRoute('onboarding', $basePath .'onboarding.php', 'GET');
$router->addRoute('welcome', $basePath .'welcome.php', 'GET');
$router->addRoute('dependency_check', null, 'GET', 'DependencyCheck@displayCheck');
$router->addRoute('status', null, 'GET', 'DependencyCheck@getStatusSummary');

$router->addRoute('register_isp_account', $basePath .'register.php', 'GET');
$router->addRoute('register_process', null, 'POST', 'Register@registerProcess');
$router->addRoute('install', $basePath .'install.php', 'GET');
$router->addRoute('install_process', null, 'POST', 'InstallController@installProcess');
$router->addRoute('login_process', null, 'POST', 'Auth@loginProcess');
$router->addRoute('dashboard', $basePath .'dashboard.php', 'GET');
$router->addRoute('accounts', $basePath .'accounts.php', 'GET');
$router->addRoute('create_account', $basePath .'create_account.php', 'GET');
$router->addRoute('suspension_page', $basePath .'suspension_page.php', 'GET');
$router->addRoute('email_smtp_settings', $basePath .'email_smtp_settings.php', 'GET');
$router->addRoute('sms_settings', $basePath .'sms_settings.php', 'GET');
$router->addRoute('config_editor', $basePath .'config_editor.php', 'GET');
$router->addRoute('currency_settings', $basePath .'currency_settings.php', 'GET');
$router->addRoute('file_manager', $basePath .'file_manager.php', 'GET');


$router->addRoute('config_editor_save', null, 'POST', 'ConfigEditor@updateSettings');
$router->addRoute('currency_settings_save', null, 'POST', 'CurrencySettings@saveSettings');
$router->addRoute('cron_job', $basePath .'cron_job.php', 'GET');
$router->addRoute('save_suspension_page', null, 'POST', 'SuspensionPage@saveSuspensionPage');
$router->addRoute('save_email_smtp_settings', null, 'POST', 'SmtpSettings@saveSmtpSettings');
$router->addRoute('test_smtp_settings', null, 'POST', 'SmtpSettings@testSmtpSettings');
$router->addRoute('test_sms_settings', null, 'POST', 'SmsSettings@testSmsSettings');
$router->addRoute('save_sms_settings', null, 'POST', 'SmsSettings@saveSmsSettings');
$router->addRoute('create_account_process', null, 'POST', 'Account@createAccountProcess');
$router->addRoute('create_account_process_test', null, 'GET', 'Account@createAccountProcessTest');

$router->addRoute('isp_account_suspend', null, 'GET', 'AccountAction@suspend');
$router->addRoute('isp_account_renew', null, 'GET', 'AccountAction@renew');
$router->addRoute('isp_account_delete', null, 'GET', 'AccountAction@delete');

$router->addRoute('change_password', $basePath .'change_password.php', 'GET');
$router->addRoute('change_password_process', null, 'POST', 'Auth@changePasswordProcess');

$router->addRoute('callback', null, 'POST', 'Subscription@callback');

// Payment Gateway Routes
$router->addRoute('payment_gateways', $basePath .'payment_gateways.php', 'GET');
$router->addRoute('payment_gateways_install', null, 'POST', 'PaymentGateways@install');
$router->addRoute('payment_gateways_configure', null, 'POST', 'PaymentGateways@configure');
$router->addRoute('payment_gateways_toggle', null, 'POST', 'PaymentGateways@toggle');
$router->addRoute('payment_process', null, 'POST', 'PaymentGateways@processPayment');
$router->addRoute('payment_webhook', null, 'POST', 'PaymentGateways@webhook');
$router->addRoute('payment_return', null, 'GET', 'PaymentGateways@returnHandler');
$router->addRoute('payment_cancel', null, 'GET', 'PaymentGateways@cancelHandler');

// API Routes for Payment Gateways
$router->addRoute('api_gateway_config', null, 'GET', 'PaymentGateways@getConfig');
$router->addRoute('api_gateway_install', null, 'GET', 'PaymentGateways@getInstallForm');
$router->addRoute('api_gateway_test', null, 'POST', 'PaymentGateways@testGateway');

// Developer Documentation
$router->addRoute('developer_docs_payment_gateways', $basePath .'developer_docs_payment_gateways.php', 'GET');

// System Files Management
$router->addRoute('system_files', $basePath .'system_files.php', 'GET');
$router->addRoute('system_files_upload', null, 'POST', 'SystemFiles@upload');
$router->addRoute('system_files_delete', null, 'POST', 'SystemFiles@delete');
$router->addRoute('system_files_download', null, 'GET', 'SystemFiles@download');


// Subscription Plans Management
$router->addRoute('subscription_plans', $basePath .'subscription_plans.php', 'GET');
$router->addRoute('subscription_plans_create', null, 'POST', 'SubscriptionPlans@create');
$router->addRoute('subscription_plans_update', null, 'POST', 'SubscriptionPlans@update');
$router->addRoute('subscription_plans_delete', null, 'GET', 'SubscriptionPlans@delete');
$router->addRoute('subscription_plans_assign', null, 'POST', 'SubscriptionPlans@assignPlan');
$router->addRoute('subscription_plans_seed', null, 'GET', 'SubscriptionPlans@seed');
