<?php
include realpath(dirname(__DIR__) . '/include/header.php');
?>
<div class="col-xl-12">
  <div class="card">
    <div class="card-body">
      <h4 class="card-title">ISP Users</h4>
      <p class="card-title-desc">List of all ISP users created in the system.</p>
      <div class="table-responsive">
        <table class="table mb-0">

          <thead class="table-light">
            <tr>
              <th>#</th>
              <th>Username</th>
              <th>Email</th>
              <th>Access</th>
              <th>Folder Path</th>
              <th>License Key</th>
              <th>License Expiry</th>
              <th>License Status</th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody>
            <?php
            // GET ALL USERS WITH LICENSE DATA USING JOIN (Better Performance)
            $query = "SELECT users.*, licenses.license_key, licenses.expiry_date, licenses.status 
              FROM users 
              LEFT JOIN licenses ON users.id = licenses.user_id 
              ORDER BY users.id DESC";

            $stmt = $conn->prepare($query);
            $stmt->execute();
            $users = $stmt->fetchAll(PDO::FETCH_ASSOC);

            if (count($users) > 0) {
              $no = 0;
              foreach ($users as $row) {
                $no++;
                $user_id = htmlspecialchars($row['id']);
                $username = htmlspecialchars($row['username']);
                $email = htmlspecialchars($row['email']);
                $domain = htmlspecialchars($row['domain']);
                $folder_path = htmlspecialchars($row['folder_path']);
                $license_key = htmlspecialchars($row['license_key'] ?? 'N/A');
                $license_expiry = htmlspecialchars($row['expiry_date'] ?? 'N/A');
                $license_status_raw = $row['status'];

                // License Badge (Ensure proper labeling)
                $license_status = ($license_status_raw == "active")
                  ? "<span class='badge badge-soft-success'>Active</span>"
                  : "<span class='badge badge-soft-danger'>Inactive</span>";

                // Determine Button Action and Label
                $btn_action = ($license_status_raw == "active") ? 'suspend' : 'renew';
                $btn_label = ($license_status_raw == "active") ? 'Suspend' : 'Renew';
                $btn_class = ($license_status_raw == "active") ? 'secondary' : 'warning';


                echo "<tr>
                    <th scope='row'>$no</th>
                    <th>$username</th>
                    <td>$email</td>
                    <td><a href='$domain/admin' target='_blank'>$domain/admin</a></td>
                    <td>$folder_path</td>
                    <td>$license_key</td>
                    <td>$license_expiry</td>
                    <td>$license_status</td>
                    <td>
                        <a href='?app_route=isp_account_$btn_action&user_id=$user_id' class='btn btn-$btn_class'>$btn_label</a>
                        <button onclick='confirmDelete($user_id)' class='btn btn-danger'>Delete</button>
                    </td>
                  </tr>";
              }
            } else {
              echo "<tr><td colspan='9' class='text-center'>No users found</td></tr>";
            }
            ?>
          </tbody>

        </table>
      </div>

    </div>
  </div>
</div>
<!-- Include SweetAlert Library -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
  function confirmDelete(userId) {
    Swal.fire({
      title: "Are you sure?",
      text: "You won't be able to revert this!",
      icon: "warning",
      showCancelButton: true,
      confirmButtonColor: "#d33",
      cancelButtonColor: "#3085d6",
      confirmButtonText: "Yes, delete it!"
    }).then((result) => {
      if (result.isConfirmed) {
        window.location.href = "?app_route=isp_account_delete&user_id=" + userId;
      }
    });
  }
</script>
<?php include realpath(dirname(__DIR__) . '/include/footer.php'); ?>