<?php
ob_start(); // Start output buffering
include realpath(dirname(__DIR__) . '/include/header.php');
// Load config file
$config_file = dirname(__DIR__) . '/../config.php';
?>

<div class="col-xl-12">
  <div class="card">
    <div class="card-body">
      <h4 class="card-title">Edit Config File</h4>
      <p class="card-title-desc">Modify your system settings.</p>
      <form method="POST" action="?app_route=config_editor_save">
        <div class="mb-3">
          <label class="form-label">Company Name</label>
          <input type="text" class="form-control" name="companyName" value="<?php echo COMPANY_NAME ?? ''; ?>" required>
        </div>
        <div class="mb-3">
          <label class="form-label">Cloudflare Token</label>
          <input type="text" class="form-control" name="cloudflare_token" value="<?php echo CLOUDFLARE_TOKEN ?? ''; ?>">
        </div>
        <div class="mb-3">
          <label class="form-label">Cloudflare Zone ID</label>
          <input type="text" class="form-control" name="cloudflare_zone_id" value="<?php echo CLOUDFLARE_ZONE_ID ?? ''; ?>">
        </div>
        <div class="mb-3">
          <label class="form-label">Telegram Bot Token</label>
          <input type="text" class="form-control" name="bot_token" value="<?php echo BOT_TOKEN ?? ''; ?>">
        </div>
        <div class="mb-3">
          <label class="form-label">Telegram Chat ID</label>
          <input type="text" class="form-control" name="chat_id" value="<?php echo CHAT_ID ?? ''; ?>">
        </div>
        <button class="btn btn-primary" type="submit">Save Changes</button>
      </form>
    </div>
  </div>
</div>

<?php
include realpath(dirname(__DIR__) . '/include/footer.php');
ob_end_flush(); // Flush output buffer
?>