<?php include 'app/include/header.php'; ?>

<?php
// Check if session is started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
?>

<div class="row">
    <div class="col-12">
        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
            <h4 class="mb-sm-0 font-size-18">Currency Settings</h4>
            <div class="page-title-right">
                <ol class="breadcrumb m-0">
                    <li class="breadcrumb-item"><a href="?app_route=dashboard">Dashboard</a></li>
                    <li class="breadcrumb-item active">Currency Settings</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-8">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">System Currency Configuration</h4>
                <p class="card-title-desc">Configure the default currency settings for your system</p>
            </div>
            <div class="card-body">
                <?php
                // Display any error messages
                if (isset($_SESSION['error'])) {
                    echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">';
                    echo '<i class="mdi mdi-block-helper me-2"></i>' . $_SESSION['error'];
                    echo '<button type="button" class="btn-close" data-bs-dismiss="alert"></button>';
                    echo '</div>';
                    unset($_SESSION['error']);
                }
                
                // Display any success messages
                if (isset($_SESSION['success'])) {
                    echo '<div class="alert alert-success alert-dismissible fade show" role="alert">';
                    echo '<i class="mdi mdi-check-circle me-2"></i>' . $_SESSION['success'];
                    echo '<button type="button" class="btn-close" data-bs-dismiss="alert"></button>';
                    echo '</div>';
                    unset($_SESSION['success']);
                }
                ?>

                <form action="?app_route=currency_settings_save" method="POST">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Currency Code <span class="text-danger">*</span></label>
                                <select class="form-select" name="currency_code" id="currency_code" required onchange="updateCurrencySymbol()">
                                    <option value="">Select Currency</option>
                                    <?php foreach ($availableCurrencies as $code => $details): ?>
                                        <option value="<?= $code ?>" 
                                                data-symbol="<?= htmlspecialchars($details['symbol']) ?>"
                                                <?= $currentSettings['currency_code'] === $code ? 'selected' : '' ?>>
                                            <?= $code ?> - <?= htmlspecialchars($details['name']) ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                                <div class="form-text">Choose the default currency for your system</div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Currency Symbol <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="currency_symbol" id="currency_symbol" 
                                       value="<?= htmlspecialchars($currentSettings['currency_symbol']) ?>" 
                                       required maxlength="5">
                                <div class="form-text">Symbol to display with prices (e.g., $, €, £)</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Symbol Position</label>
                                <select class="form-select" name="currency_position">
                                    <option value="before" <?= $currentSettings['currency_position'] === 'before' ? 'selected' : '' ?>>
                                        Before amount (e.g., $100.00)
                                    </option>
                                    <option value="after" <?= $currentSettings['currency_position'] === 'after' ? 'selected' : '' ?>>
                                        After amount (e.g., 100.00$)
                                    </option>
                                </select>
                                <div class="form-text">Where to display the currency symbol</div>
                            </div>
                        </div>
                        
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Preview</label>
                                <div class="form-control bg-light" id="currency_preview">
                                    <?php
                                    $sampleAmount = '99.99';
                                    if ($currentSettings['currency_position'] === 'before') {
                                        echo htmlspecialchars($currentSettings['currency_symbol']) . $sampleAmount;
                                    } else {
                                        echo $sampleAmount . htmlspecialchars($currentSettings['currency_symbol']);
                                    }
                                    ?>
                                </div>
                                <div class="form-text">Preview of how currency will be displayed</div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-12">
                            <button type="submit" class="btn btn-primary">
                                <i class="bx bx-save me-1"></i> Save Currency Settings
                            </button>
                            <a href="?app_route=dashboard" class="btn btn-secondary ms-2">
                                <i class="bx bx-arrow-back me-1"></i> Back to Dashboard
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-lg-4">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Popular Currencies</h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>Code</th>
                                <th>Symbol</th>
                                <th>Name</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $popularCurrencies = ['USD', 'EUR', 'GBP', 'JPY', 'AUD', 'CAD', 'KES', 'NGN', 'GHS', 'UGX'];
                            foreach ($popularCurrencies as $code):
                                if (isset($availableCurrencies[$code])):
                            ?>
                                <tr>
                                    <td><strong><?= $code ?></strong></td>
                                    <td><?= htmlspecialchars($availableCurrencies[$code]['symbol']) ?></td>
                                    <td><?= htmlspecialchars($availableCurrencies[$code]['name']) ?></td>
                                </tr>
                            <?php 
                                endif;
                            endforeach; 
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">Important Notes</h4>
            </div>
            <div class="card-body">
                <ul class="mb-0">
                    <li>Currency changes will affect all future transactions</li>
                    <li>Existing records will maintain their original currency</li>
                    <li>Make sure to communicate currency changes to your users</li>
                    <li>Consider exchange rates when switching currencies</li>
                </ul>
            </div>
        </div>
    </div>
</div>

<script>
function updateCurrencySymbol() {
    const currencySelect = document.getElementById('currency_code');
    const symbolInput = document.getElementById('currency_symbol');
    const selectedOption = currencySelect.options[currencySelect.selectedIndex];
    
    if (selectedOption && selectedOption.dataset.symbol) {
        symbolInput.value = selectedOption.dataset.symbol;
        updatePreview();
    }
}

function updatePreview() {
    const symbol = document.getElementById('currency_symbol').value;
    const position = document.querySelector('select[name="currency_position"]').value;
    const preview = document.getElementById('currency_preview');
    const amount = '99.99';
    
    if (position === 'before') {
        preview.textContent = symbol + amount;
    } else {
        preview.textContent = amount + symbol;
    }
}

// Update preview when position or symbol changes
document.querySelector('select[name="currency_position"]').addEventListener('change', updatePreview);
document.getElementById('currency_symbol').addEventListener('input', updatePreview);
</script>

<?php include 'app/include/footer.php'; ?>
