<?php include 'app/include/pre_install_header.php'; ?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <h4 class="page-title">System Dependency Check</h4>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h4 class="header-title mb-3">
                        <i class="mdi mdi-shield-check-outline"></i>
                        Pre-Installation System Check
                    </h4>
                    
                    <?php if ($allPassed): ?>
                        <div class="alert alert-success" role="alert">
                            <i class="mdi mdi-check-circle-outline"></i>
                            <strong>Great!</strong> All system requirements are met. You can proceed with the installation.
                            <div class="mt-3">
                                <a href="?page=welcome" class="btn btn-success">
                                    <i class="mdi mdi-arrow-right"></i> Continue to Welcome Page
                                </a>
                                <a href="?page=install" class="btn btn-primary">
                                    <i class="mdi mdi-download"></i> Proceed to Installation
                                </a>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-warning" role="alert">
                            <i class="mdi mdi-alert-outline"></i>
                            <strong>Attention!</strong> Some system requirements are not met. Please resolve the issues below before proceeding.
                        </div>
                    <?php endif; ?>

                    <!-- PHP Version Check -->
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <div class="card border-<?php echo $dependencies['php_version']['status'] ? 'success' : 'danger'; ?>">
                                <div class="card-header bg-<?php echo $dependencies['php_version']['status'] ? 'success' : 'danger'; ?> text-white">
                                    <h5 class="card-title mb-0">
                                        <i class="mdi mdi-language-php"></i>
                                        PHP Version Check
                                        <span class="float-end">
                                            <i class="mdi mdi-<?php echo $dependencies['php_version']['status'] ? 'check-circle' : 'alert-circle'; ?>"></i>
                                        </span>
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <p><strong>Required:</strong> <?php echo $dependencies['php_version']['required']; ?> or higher</p>
                                    <p><strong>Current:</strong> <?php echo $dependencies['php_version']['current']; ?></p>
                                    <p class="mb-0"><strong>Status:</strong> <?php echo $dependencies['php_version']['message']; ?></p>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Extensions Check -->
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <div class="card border-secondary">
                                <div class="card-header bg-secondary text-white">
                                    <h5 class="card-title mb-0">
                                        <i class="mdi mdi-puzzle-outline"></i>
                                        PHP Extensions
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <?php foreach ($dependencies['extensions'] as $ext => $info): ?>
                                            <div class="col-md-6 mb-2">
                                                <div class="d-flex align-items-center">
                                                    <i class="mdi mdi-<?php echo $info['status'] ? 'check-circle text-success' : 'close-circle text-danger'; ?> me-2"></i>
                                                    <div>
                                                        <strong><?php echo strtoupper($ext); ?></strong><br>
                                                        <small class="text-muted"><?php echo $info['description']; ?></small>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Permissions Check -->
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <div class="card border-secondary">
                                <div class="card-header bg-secondary text-white">
                                    <h5 class="card-title mb-0">
                                        <i class="mdi mdi-folder-lock-outline"></i>
                                        File & Directory Permissions
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-sm">
                                            <thead>
                                                <tr>
                                                    <th>Path</th>
                                                    <th>Description</th>
                                                    <th>Readable</th>
                                                    <th>Writable</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($dependencies['permissions'] as $path => $info): ?>
                                                    <tr>
                                                        <td><code><?php echo htmlspecialchars($path); ?></code></td>
                                                        <td><?php echo $info['description']; ?></td>
                                                        <td>
                                                            <i class="mdi mdi-<?php echo $info['readable'] ? 'check text-success' : 'close text-danger'; ?>"></i>
                                                        </td>
                                                        <td>
                                                            <i class="mdi mdi-<?php echo $info['writable'] ? 'check text-success' : 'close text-danger'; ?>"></i>
                                                        </td>
                                                        <td>
                                                            <span class="badge bg-<?php echo $info['status'] ? 'success' : 'danger'; ?>">
                                                                <?php echo $info['status'] ? 'OK' : 'Error'; ?>
                                                            </span>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Composer Dependencies -->
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <div class="card border-<?php echo $dependencies['composer']['status'] ? 'success' : 'warning'; ?>">
                                <div class="card-header bg-<?php echo $dependencies['composer']['status'] ? 'success' : 'warning'; ?> text-white">
                                    <h5 class="card-title mb-0">
                                        <i class="mdi mdi-package-variant"></i>
                                        Composer Dependencies
                                        <span class="float-end">
                                            <i class="mdi mdi-<?php echo $dependencies['composer']['status'] ? 'check-circle' : 'alert-circle'; ?>"></i>
                                        </span>
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="d-flex align-items-center">
                                                <i class="mdi mdi-<?php echo $dependencies['composer']['composer_lock'] ? 'check text-success' : 'close text-danger'; ?> me-2"></i>
                                                <span>composer.lock exists</span>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="d-flex align-items-center">
                                                <i class="mdi mdi-<?php echo $dependencies['composer']['vendor_dir'] ? 'check text-success' : 'close text-danger'; ?> me-2"></i>
                                                <span>vendor/ directory</span>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="d-flex align-items-center">
                                                <i class="mdi mdi-<?php echo $dependencies['composer']['autoload'] ? 'check text-success' : 'close text-danger'; ?> me-2"></i>
                                                <span>autoload.php</span>
                                            </div>
                                        </div>
                                    </div>
                                    <p class="mt-2 mb-0"><strong>Status:</strong> <?php echo $dependencies['composer']['message']; ?></p>
                                    <?php if (!$dependencies['composer']['status']): ?>
                                        <div class="alert alert-info mt-2">
                                            <strong>How to fix:</strong> Run <code>composer install</code> in the project root directory.
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Database Connection -->
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <div class="card border-<?php echo $dependencies['database']['status'] ? 'success' : 'warning'; ?>">
                                <div class="card-header bg-<?php echo $dependencies['database']['status'] ? 'success' : 'warning'; ?> text-white">
                                    <h5 class="card-title mb-0">
                                        <i class="mdi mdi-database"></i>
                                        Database Configuration
                                        <span class="float-end">
                                            <i class="mdi mdi-<?php echo $dependencies['database']['status'] ? 'check-circle' : 'alert-circle'; ?>"></i>
                                        </span>
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <p class="mb-0"><strong>Status:</strong> <?php echo $dependencies['database']['message']; ?></p>
                                    <?php if (!$dependencies['database']['status'] && $dependencies['database']['configurable']): ?>
                                        <div class="alert alert-info mt-2">
                                            <strong>Note:</strong> Database configuration will be set up during the installation process.
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="row">
                        <div class="col-12">
                            <div class="text-center">
                                <button type="button" class="btn btn-secondary" onclick="location.reload()">
                                    <i class="mdi mdi-refresh"></i> Recheck
                                </button>
                                
                                <?php if ($allPassed): ?>
                                    <a href="?page=welcome" class="btn btn-success">
                                        <i class="mdi mdi-arrow-right"></i> Continue
                                    </a>
                                <?php else: ?>
                                    <button type="button" class="btn btn-primary" disabled>
                                        <i class="mdi mdi-lock"></i> Fix Issues to Continue
                                    </button>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // Auto-refresh every 30 seconds to check for updates
    setTimeout(function() {
        location.reload();
    }, 30000);
</script>

<?php include 'app/include/pre_install_footer.php'; ?>
