<?php
include realpath(dirname(__DIR__) . '/include/header.php');

// Simple Markdown to HTML converter
function markdownToHtml($markdown) {
    // Headers
    $markdown = preg_replace('/^# (.+)$/m', '<h1>$1</h1>', $markdown);
    $markdown = preg_replace('/^## (.+)$/m', '<h2>$1</h2>', $markdown);
    $markdown = preg_replace('/^### (.+)$/m', '<h3>$1</h3>', $markdown);
    $markdown = preg_replace('/^#### (.+)$/m', '<h4>$1</h4>', $markdown);
    
    // Bold text
    $markdown = preg_replace('/\*\*(.+?)\*\*/', '<strong>$1</strong>', $markdown);
    
    // Italic text
    $markdown = preg_replace('/\*(.+?)\*/', '<em>$1</em>', $markdown);
    
    // Code blocks
    $markdown = preg_replace('/```(\w+)?\n(.*?)\n```/s', '<pre><code class="language-$1">$2</code></pre>', $markdown);
    
    // Inline code
    $markdown = preg_replace('/`([^`]+)`/', '<code>$1</code>', $markdown);
    
    // Links
    $markdown = preg_replace('/\[([^\]]+)\]\(([^)]+)\)/', '<a href="$2">$1</a>', $markdown);
    
    // Lists
    $markdown = preg_replace('/^- (.+)$/m', '<li>$1</li>', $markdown);
    $markdown = preg_replace('/(<li>.*<\/li>)/s', '<ul>$1</ul>', $markdown);
    
    // Paragraphs
    $markdown = preg_replace('/\n\n/', '</p><p>', $markdown);
    $markdown = '<p>' . $markdown . '</p>';
    
    // Clean up empty paragraphs
    $markdown = preg_replace('/<p><\/p>/', '', $markdown);
    
    return $markdown;
}
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <h4 class="page-title">Payment Gateway Development Documentation</h4>
                <p class="text-muted">Complete guide for developing custom payment gateway addons</p>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">
                            <i class="mdi mdi-book-open"></i> Developer Documentation
                        </h5>
                        <div>
                            <a href="?app_route=payment_gateways" class="btn btn-sm btn-secondary">
                                <i class="mdi mdi-arrow-left"></i> Back to Payment Gateways
                            </a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="documentation-content">
                        <style>
                            .documentation-content {
                                font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
                                line-height: 1.6;
                            }
                            .documentation-content h1 {
                                color: #2c3e50;
                                border-bottom: 2px solid #3498db;
                                padding-bottom: 10px;
                                margin-top: 30px;
                                margin-bottom: 20px;
                            }
                            .documentation-content h2 {
                                color: #34495e;
                                margin-top: 25px;
                                margin-bottom: 15px;
                            }
                            .documentation-content h3 {
                                color: #5a6c7d;
                                margin-top: 20px;
                                margin-bottom: 10px;
                            }
                            .documentation-content h4 {
                                color: #6c757d;
                                margin-top: 15px;
                                margin-bottom: 8px;
                            }
                            .documentation-content pre {
                                background: #f8f9fa;
                                border: 1px solid #e9ecef;
                                border-radius: 4px;
                                padding: 15px;
                                overflow-x: auto;
                                margin: 15px 0;
                            }
                            .documentation-content code {
                                background: #f1f3f4;
                                padding: 2px 6px;
                                border-radius: 3px;
                                font-family: 'Courier New', monospace;
                                font-size: 90%;
                            }
                            .documentation-content pre code {
                                background: transparent;
                                padding: 0;
                            }
                            .documentation-content ul {
                                margin: 10px 0;
                                padding-left: 20px;
                            }
                            .documentation-content li {
                                margin: 5px 0;
                            }
                            .documentation-content p {
                                margin: 10px 0;
                            }
                            .documentation-content a {
                                color: #3498db;
                                text-decoration: none;
                            }
                            .documentation-content a:hover {
                                color: #2980b9;
                                text-decoration: underline;
                            }
                            .documentation-content strong {
                                color: #2c3e50;
                            }
                        </style>
                        
                        <?php echo markdownToHtml($content); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Add syntax highlighting for code blocks
document.addEventListener('DOMContentLoaded', function() {
    // Add copy buttons to code blocks
    document.querySelectorAll('pre code').forEach(function(block) {
        var button = document.createElement('button');
        button.className = 'btn btn-sm btn-outline-secondary position-absolute';
        button.style.top = '10px';
        button.style.right = '10px';
        button.innerHTML = '<i class="mdi mdi-content-copy"></i>';
        button.onclick = function() {
            navigator.clipboard.writeText(block.textContent).then(function() {
                button.innerHTML = '<i class="mdi mdi-check text-success"></i>';
                setTimeout(function() {
                    button.innerHTML = '<i class="mdi mdi-content-copy"></i>';
                }, 2000);
            });
        };
        
        block.parentElement.style.position = 'relative';
        block.parentElement.appendChild(button);
    });
});
</script>

<?php
include realpath(dirname(__DIR__) . '/include/footer.php');
?>
