<?php
include realpath(dirname(__DIR__) . '/include/header.php');

// Get settings from database
$stmt = $conn->prepare("SELECT setting_name, setting_value FROM settings WHERE setting_name IN ('smtp_host', 'smtp_port', 'smtp_user', 'smtp_pass')");
$stmt->execute();
$settings = [];
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
  $settings[$row['setting_name']] = $row['setting_value'];
}
$stmt->closeCursor();
?>

<div class="col-xl-12">
  <div class="card">
    <div class="card-body">
      <h4 class="card-title">SMTP Settings</h4>
      <p class="card-title-desc">Configure your SMTP settings for email notifications.</p>
      <form class="needs-validation" action="?app_route=save_email_smtp_settings" method="POST" novalidate>
        <div class="row">
          <div class="col-md-6">
            <div class="mb-3">
              <label for="smtp_host" class="form-label">SMTP Host</label>
              <input type="text" class="form-control" id="smtp_host" placeholder="SMTP Host" name="smtp_host" required value="<?php echo isset($settings['smtp_host']) ? $settings['smtp_host'] : ''; ?>">
            </div>
          </div>
          <div class="col-md-6">
            <div class="mb-3">
              <label for="smtp_port" class="form-label">SMTP Port</label>
              <input type="text" class="form-control" id="smtp_port" placeholder="SMTP Port" name="smtp_port" required value="<?php echo isset($settings['smtp_port']) ? $settings['smtp_port'] : ''; ?>">
            </div>
          </div>
        </div>
        <div class="row">
          <div class="col-md-6">
            <div class="mb-3">
              <label for="smtp_user" class="form-label">SMTP User</label>
              <input type="text" class="form-control" id="smtp_user" placeholder="SMTP User" name="smtp_user" required value="<?php echo isset($settings['smtp_user']) ? $settings['smtp_user'] : ''; ?>">
            </div>
          </div>
          <div class="col-md-6">
            <div class="mb-3">
              <label for="smtp_pass" class="form-label">SMTP Password</label>
              <input type="text" class="form-control" id="smtp_pass" placeholder="SMTP Password" name="smtp_pass" required value="<?php echo isset($settings['smtp_pass']) ? $settings['smtp_pass'] : ''; ?>">
            </div>
          </div>
        </div>
        <button class="btn btn-primary mt-2 me-2 waves-effect waves-light float-end" type="submit" name="save_smtp_settings">Save Settings</button>
        <button type="button" class="btn btn-success mt-2 me-2 waves-effect waves-light float-end" data-bs-toggle="modal" data-bs-target="#testSmtpModal">Test SMTP</button>
      </form>
    </div>
  </div>

  <!-- Test SMTP Modal -->
  <div class="modal fade" id="testSmtpModal" tabindex="-1" aria-labelledby="testSmtpModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="testSmtpModalLabel">Test SMTP Settings</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form action="?app_route=test_smtp_settings" method="POST" class="needs-validation" novalidate>
            <div class="mb-3">
              <label for="test_email" class="form-label">Test Email Address</label>
              <input type="email" class="form-control" id="test_email" name="test_email" required placeholder="Enter email address to send test email" value="<?php echo isset($settings['test_email']) ? $settings['test_email'] : ''; ?>">
            </div>
            <button type="submit" class="btn btn-primary" name="test_smtp_settings"><i class="fas fa-paper-plane"></i> Send Test Email</button>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>



<?php
include realpath(dirname(__DIR__) . '/include/footer.php');
?>