<?php
include realpath(dirname(__DIR__) . '/include/auth_header.php');
?>
<div class="account-pages my-5 pt-sm-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-8 col-lg-6 col-xl-5">
                <div class="card overflow-hidden">
                    <div class="bg-primary bg-soft">
                        <div class="row">
                            <div class="col-7">
                                <div class="text-primary p-4">
                                    <h5 class="text-primary">Welcome Back to NuxSaaS !</h5>
                                    <p>Sign in to continue to NuxSaaS.</p>
                                </div>
                            </div>
                            <div class="col-5 align-self-end">
                                <img src="<?= BASE_RESOURCES_URL ?>assets/images/profile-img.png" alt="" class="img-fluid">
                            </div>
                        </div>
                    </div>
                    <div class="card-body pt-0">
                        <div class="auth-logo">
                            <a href="?app_route=install" class="auth-logo-light">
                                <div class="avatar-md profile-user-wid mb-4">
                                    <span class="avatar-title rounded-circle bg-light">
                                        <img src="<?= BASE_RESOURCES_URL ?>assets/images/logo-light.svg" alt="" class="rounded-circle" height="34">
                                    </span>
                                </div>
                            </a>

                            <a href="?app_route=install" class="auth-logo-dark">
                                <div class="avatar-md profile-user-wid mb-4">
                                    <span class="avatar-title rounded-circle bg-light">
                                        <img src="<?= BASE_RESOURCES_URL ?>assets/images/logo.svg" alt="" class="rounded-circle" height="34">
                                    </span>
                                </div>
                            </a>
                        </div>
                        <div class="p-2">
                            <?php
                            // Display success message
                            if (isset($_SESSION['success'])) {
                                echo '<div class="alert alert-success alert-dismissible fade show" role="alert">';
                                echo '<i class="mdi mdi-check-circle me-2"></i>' . $_SESSION['success'];
                                echo '<button type="button" class="btn-close" data-bs-dismiss="alert"></button>';
                                echo '</div>';
                                unset($_SESSION['success']);
                            }
                            
                            // Display error message
                            if (isset($_SESSION['error'])) {
                                echo '<div class="alert alert-danger alert-dismissible fade show" role="alert">';
                                echo '<i class="mdi mdi-alert-circle me-2"></i>' . $_SESSION['error'];
                                echo '<button type="button" class="btn-close" data-bs-dismiss="alert"></button>';
                                echo '</div>';
                                unset($_SESSION['error']);
                            }
                            ?>
                            <form class="form-horizontal" action="?app_route=login_process" method="POST">

                                <div class="mb-3">
                                    <label for="username" class="form-label">Username</label>
                                    <input type="text" class="form-control" id="username" placeholder="Enter username" name="username" required>
                                </div>

                                <div class="mb-3">
                                    <label class="form-label">Password</label>
                                    <div class="input-group auth-pass-inputgroup">
                                        <input type="password" class="form-control" placeholder="Enter password" aria-label="Password" aria-describedby="password-addon" name="password" required>
                                        <button class="btn btn-light " type="button" id="password-addon"><i class="mdi mdi-eye-outline"></i></button>
                                    </div>
                                </div>

                                <div class="mt-3 d-grid">
                                    <button class="btn btn-primary waves-effect waves-light" type="submit" name="login">Log In</button>
                                </div>
                            </form>
                        </div>

                    </div>
                </div>
                <div class="mt-5 text-center">
                    <div>
                        <p>© <script>
                                document.write(new Date().getFullYear())
                            </script> Powered by <a href="https://alvinkiveu.com/" target="_blank" class="text-primary">Alvin Kiveu</a> </p>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
<?php
include realpath(dirname(__DIR__) . '/include/footer.php');
?>