<?php
// Include function helper and check if system is already installed
$path = realpath(dirname(__DIR__) . '/include/function.php');
if ($path) {
    include $path;
    
    // Check if system is already installed
    if (isSystemInstalled()) {
        header('Location: ?app_route=login');
        exit;
    }
}

include realpath(dirname(__DIR__) . '/include/install_header.php');

// Get main domain
$main_domain = $_SERVER['HTTP_HOST'];

// If already installed, redirect to login
if (configExists() && isInstalled()) {
    header('Location: ?app_route=login');
    exit;
}
?>
<div class="account-pages my-5 pt-sm-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-12 col-lg-12 col-xl-10">
                <div class="card overflow-hidden">
                    <div class="bg-primary bg-soft">
                        <div class="row">
                            <div class="col-7">
                                <div class="text-primary p-4">
                                    <h5 class="text-primary">NuxSaaS Installation</h5>
                                    <p>Fill the form below to install NuxSaaS</p>
                                </div>
                            </div>
                            <div class="col-5 align-self-end">
                                <img src="<?= BASE_RESOURCES_URL ?>assets/images/profile-img.png" alt="" class="img-fluid">
                            </div>
                        </div>
                    </div>
                    <div class="card-body pt-0">
                        <div>
                            <a href="?app_route=install">
                                <div class="avatar-md profile-user-wid mb-4">
                                    <span class="avatar-title rounded-circle bg-light">
                                        <img src="<?= BASE_RESOURCES_URL ?>assets/images/logo.svg" alt="" class="rounded-circle" height="34">
                                    </span>
                                </div>
                            </a>
                        </div>
                        <div class="p-2 mt-4 w-100">


                            <form class="needs-validation row" novalidate action="?app_route=install_process" method="POST">

                                <div class="mb-2 col-md-12">
                                    <p class="text-muted">General Information
                                        <br>
                                        <span class="text-info">
                                            <strong>Important:</strong>
                                            Domain format only domain (e.g. example.com)
                                        </span>
                                    </p>
                                </div>
                                <div class="mb-3 col-md-12">
                                    <label for="companyName" class="form-label">Company Name / Organization Name</label>
                                    <input type="text" class="form-control" id="companyName" placeholder="Enter company name" name="companyName" required>
                                    <div class="invalid-feedback">
                                        Please Enter Company Name / Organization Name
                                    </div>
                                </div>


                                <div class="mb-3 col-md-6">
                                    <label for="serverip" class="form-label">Server IP Address</label>
                                    <input type="text" class="form-control" id="serverIP" placeholder="1.22.333.4" name="serverIP" required>
                                    <div class="invalid-feedback">
                                        Please Enter Server IP Address
                                    </div>
                                </div>
                                <div class="mb-3 col-md-6">
                                    <label for="serverip" class="form-label">Main Domain</label>
                                    <input type="text" class="form-control" id="mainDomain" placeholder="Enter main domain" name="mainDomain" required value="<?php echo $main_domain; ?>">
                                    <div class="invalid-feedback">
                                        Please Enter Main Domain
                                    </div>
                                </div>


                                <div class="mb-2 col-md-12">
                                    <p class="text-muted">Database Information
                                        <br>
                                        <span class="text-info">
                                            Fill the form below with your MySQL database information
                                        </span>
                                </div>
                                <div class="mb-3 col-md-12">
                                    <label for="mysql_host" class="form-label">MySQL Host</label>
                                    <input type="text" class="form-control" id="mysql_host" placeholder="Enter MySQL Host" name="mysql_host" required>
                                    <div class="invalid-feedback">
                                        Please Enter MySQL Host
                                    </div>
                                </div>

                                <div class="mb-3 col-md-6">
                                    <label for="mysql_user" class="form-label">MySQL User</label>
                                    <input type="text" class="form-control" id="mysql_user" placeholder="Enter MySQL User" name="mysql_user" required>
                                    <div class="invalid-feedback">
                                        Please Enter MySQL User
                                    </div>
                                </div>

                                <div class="mb-3 col-md-6">
                                    <label for="mysql_password" class="form-label">MySQL Password</label>
                                    <input type="password" class="form-control" id="mysql_password" placeholder="Enter MySQL Password" name="mysql_password">
                                    <div class="invalid-feedback">
                                        Please Enter MySQL Password
                                    </div>
                                </div>

                                <div class="mb-2 col-md-12">
                                    <p class="text-muted">Cloudflare Information <br>
                                        <span class="text-info">Login to your Cloudflare account and get the API Token and Zone ID <a href="https://dash.cloudflare.com/profile/api-tokens" target="_blank">Click Here</a></span>
                                    </p>
                                </div>

                                <div class="mb-3 col-md-6">
                                    <label for="cloudflareToken" class="form-label">Cloudflare Token</label>
                                    <input type="text" class="form-control" id="cloudflareToken" placeholder="Enter Cloudflare Token" name="cloudflare_token" required>
                                    <div class="invalid-feedback">
                                        Please Enter Cloudflare Token
                                    </div>
                                </div>

                                <div class="mb-3 col-md-6">
                                    <label for="cloudflareZoneID" class="form-label">Cloudflare Zone ID</label>
                                    <input type="text" class="form-control" id="cloudflareZoneID" placeholder="Enter Cloudflare Zone ID" name="cloudflare_zone_id" required>
                                    <div class="invalid-feedback">
                                        Please Enter Cloudflare Zone ID
                                    </div>
                                </div>

                                <div class="mb-2 col-md-12">
                                    <p class="text-muted">Telegram Information<br>
                                        <span class="text-info">Create a Telegram Bot <a href="https://telegram.me/BotFather" target="_blank">Click Here</a> and get the Bot Token and Chat ID <a href="https://telegram.me/userinfobot" target="_blank">Click Here</a>
                                            To watch youtube video on how create telegram bot <a href="https://youtu.be/yZYtuQ2C6YA?si=j4lNEXUJzz8k3DHm" target="_blank">Click Here</a></span>
                                    </p>
                                </div>

                                <div class="mb-3 col-md-6">
                                    <label for="bot_token" class="form-label">Telegram Bot Token</label>
                                    <input type="text" class="form-control" id="bot_token" placeholder="Enter Telegram Bot Token" name="bot_token" required>
                                    <div class="invalid-feedback">
                                        Please Enter Telegram Bot Token
                                    </div>
                                </div>

                                <div class="mb-3 col-md-6">
                                    <label for="chat_id" class="form-label">Telegram Chat ID</label>
                                    <input type="text" class="form-control" id="chat_id" placeholder="Enter Telegram Chat ID" name="chat_id" required>
                                    <div class="invalid-feedback">
                                        Please Enter Telegram Chat ID
                                    </div>
                                </div>





                                <div class="mt-4 d-grid">
                                    <button class="btn btn-primary waves-effect waves-light" type="submit" name="Install">INSTALL NuxSaaS</button>
                                </div>



                            </form>
                        </div>

                    </div>
                </div>


            </div>
        </div>
    </div>
</div>
<?php
include realpath(dirname(__DIR__) . '/include/install_footer.php');
?>