<?php
include realpath(dirname(__DIR__) . '/include/install_header.php');
?>
<div class="account-pages my-5 pt-sm-5">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-md-12 col-lg-12 col-xl-12">
        <div class="card overflow-hidden">
          <div class="bg-primary bg-soft">
            <div class="row">
              <div class="col-7">
                <div class="text-primary p-4">
                  <h5 class="text-primary">REGISTER</h5>
                  <p>Sign in to continue to</p>
                  <h4 class="text-primary">ISP Management System</h4>
                </div>

              </div>
              <div class="col-5 align-self-end">
                <img src="<?= BASE_RESOURCES_URL ?>assets/images/profile-img.png" alt="" class="img-fluid">
              </div>
            </div>
          </div>
          <div class="card-body pt-0">
            <div class="auth-logo">
              <a href="?app_route=install" class="auth-logo-light">
                <div class="avatar-md profile-user-wid mb-4">
                  <span class="avatar-title rounded-circle bg-light">
                    <img src="<?= BASE_RESOURCES_URL ?>assets/images/logo-light.svg" alt="" class="rounded-circle" height="34">
                  </span>
                </div>
              </a>
              <a href="?app_route=install" class="auth-logo-dark">
                <div class="avatar-md profile-user-wid mb-4">
                  <span class="avatar-title rounded-circle bg-light">
                    <img src="<?= BASE_RESOURCES_URL ?>assets/images/logo.svg" alt="" class="rounded-circle" height="34">
                  </span>
                </div>
              </a>
            </div>
            <div class="p-2">
              <form class="form-horizontal" action="?app_route=register_process" method="POST">

                <div class="row">
                  <div class="col-md-12">
                    <div class="mb-3">
                      <label for="isp_name" class="form-label">ISP Wifi Name</label>
                      <input type="text" class="form-control" id="isp_name" placeholder="ISP Wifi Name" name="isp_name" required>
                    </div>
                  </div>
                </div>

                <div class="row">
                  <div class="col-md-6">
                    <div class="mb-3">
                      <label for="email" class="form-label">Email</label>
                      <input type="email" class="form-control" id="email" placeholder="Email" name="email" required>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="mb-3">
                      <label for="phone" class="form-label">Phone Number</label>
                      <input type="text" class="form-control" id="phone" placeholder="Phone Number" name="phone" required>
                    </div>
                  </div>
                </div>

                <div class="row">
                  <div class="col-md-12">
                    <div class="mb-3">
                      <label for="subdomain" class="form-label">Subdomain</label>
                      <div class="position-relative">
                        <input type="text" class="form-control" id="subdomain" placeholder="Subdomain" name="subdomain" required>
                        <span class="position-absolute end-0 top-50 translate-middle-y px-3 text-muted">
                          .<?php echo MAIN_DOMAIN; ?>
                        </span>
                      </div>
                    </div>
                  </div>
                  <div class="col-md-12">
                    <div class="mb-3">
                      <label for="username" class="form-label">Username</label>
                      <input type="text" class="form-control" id="username" placeholder="Username" name="username" required>
                    </div>
                  </div>
                </div>

                <div class="row">

                  <div class="col-md-6">
                    <div class="mb-3">
                      <label for="password" class="form-label">Password</label>
                      <input type="password" class="form-control" id="password" placeholder="Password" name="password" required onkeyup="checkPasswordStrength()">
                      <small id="password-strength" class="text-muted"></small>
                    </div>
                  </div>
                  <div class="col-md-6">
                    <div class="mb-3">
                      <label for="confirm_password" class="form-label">Confirm Password</label>
                      <input type="password" class="form-control" id="confirm_password" placeholder="Confirm Password" name="confirm_password" required>
                    </div>
                  </div>
                </div>
                
                <div class="mb-3 form-check">
                  <input type="checkbox" class="form-check-input" id="terms" required>
                  <label class="form-check-label" for="terms">I agree to the <a href="#">Terms & Conditions</a></label>
                </div>

                <div class="text-end mt-3">
                  <button type="submit" class="btn btn-primary">Register</button>
                </div>

              </form>
            </div>
          </div>
        </div>
        <div class="mt-5 text-center">
          <div>
            <p>© <script>
                document.write(new Date().getFullYear())
              </script> Powered by <a href="https://alvinkiveu.com/" target="_blank" class="text-primary">Alvin Kiveu</a></p>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php
include realpath(dirname(__DIR__) . '/include/install_footer.php');
?>