<?php
include realpath(dirname(__DIR__) . '/include/header.php');

// Get settings from database
$stmt = $conn->prepare("SELECT setting_name, setting_value FROM settings WHERE setting_name IN ('sms_api_url', 'sms_api_key')");
$stmt->execute();
$settings = [];
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
  $settings[$row['setting_name']] = $row['setting_value'];
}
$stmt->closeCursor();
?>

<div class="col-xl-12">
  <div class="card">
    <div class="card-body">
      <h4 class="card-title">SMS API Settings</h4>
      <p class="card-title-desc">Configure your SMS API settings for sending messages.</p>
      
      
      <form class="needs-validation" action="?app_route=save_sms_settings" method="POST" novalidate>
        <div class="row">
          <div class="col-md-12">
            <div class="mb-3">
              <label for="sms_api_url" class="form-label">SMS API URL</label>
              <input type="text" class="form-control" id="sms_api_url" name="sms_api_url" required value="<?php echo isset($settings['sms_api_url']) ? $settings['sms_api_url'] : ''; ?>" placeholder="https://domain/?param_number=[number]&param_text=[text]&secret">
            </div>
          </div>
        </div>
        <button class="btn btn-primary mt-2 me-2 waves-effect waves-light float-end" type="submit" name="save_sms_settings">Save Settings</button>
        <button type="button" class="btn btn-success mt-2 me-2 waves-effect waves-light float-end" data-bs-toggle="modal" data-bs-target="#testSmsModal">Test SMS</button>
      </form>
    </div>
  </div>

  <!-- Test SMS Modal -->
  <div class="modal fade" id="testSmsModal" tabindex="-1" aria-labelledby="testSmsModalLabel" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="testSmsModalLabel">Test SMS Settings</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form action="?app_route=test_sms_settings" method="POST" class="needs-validation" novalidate>
            <div class="mb-3">
              <label for="test_number" class="form-label">Test Phone Number</label>
              <input type="text" class="form-control" id="test_number" name="test_number" required placeholder="Enter phone number to send test SMS">
            </div>
            <button type="submit" class="btn btn-primary" name="test_sms_settings"><i class="fas fa-paper-plane"></i> Send Test SMS</button>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>

<?php
include realpath(dirname(__DIR__) . '/include/footer.php');
?>