<?php
include dirname(__DIR__) . '/include/header.php';
$suspend_file = dirname(__DIR__) . '/include/suspend.html';
if (file_exists($suspend_file)) {
  $suspend_content = file_get_contents($suspend_file);
} else {
  $suspend_content = <<<HTML
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Account Suspended</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <style>
        body {
            background-color: #f8d7da;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .suspend-container {
            text-align: center;
            background: white;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        }
        .icon {
            font-size: 80px;
            color: #dc3545;
        }
    </style>
</head>
<body>
    <div class="suspend-container">
        <div class="icon">⚠️</div>
        <h1 class="text-danger">Account Suspended</h1>
        <p>Your account <strong>{username}</strong> has been suspended.</p>
        <p>Please contact support for more details.</p>
        <a href="mailto:support@yourdomain.com" class="btn btn-danger mt-3">Contact Support</a>
    </div>
</body>
</html>
HTML;
}
?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.5/codemirror.min.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.5/theme/dracula.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.5/codemirror.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.5/mode/htmlmixed/htmlmixed.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.5/addon/edit/closetag.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/codemirror/5.65.5/addon/edit/closebrackets.min.js"></script>
<style>
  iframe {
    width: 100%;
    height: 500px;
    border: 1px solid #ccc;
    background: white;
  }
</style>


<div class="col-xl-6">
  <h2>Customize Suspension Page</h2>
  <p>Edit the HTML content for the suspension page below.</p>
  <textarea id="codeEditor" class="form-control" rows="15"><?php echo htmlspecialchars($suspend_content, ENT_QUOTES, 'UTF-8'); ?></textarea>
  <button id="saveBtn" class="btn btn-success mt-3 w-100">Save</button>
  <div class="mt-3 p-3 border rounded bg-light">
    <h5 class="text-primary">Placeholders</h5>
    <p>You can use the following placeholders in your HTML content:</p>
    <ul class="list-unstyled mb-2">
      <li><strong>{username}</strong> - Will be replaced with the actual username.</li>
      <li><strong>{license_key}</strong> - Will be replaced with the actual license key.</li>
      <li><strong>{license_status}</strong> - Will be replaced with the actual license status.</li>
      <li><strong>{license_expiry}</strong> - Will be replaced with the actual license expiry date.</li>
    </ul>
    <p class="text-muted"><em>Note:</em> The above placeholders will be replaced with actual values when the suspension page is displayed.</p>
  </div>
</div>
<div class="col-xl-6">
  <h2>Preview</h2>
  <p>Live preview of the suspension page.</p>
  <iframe id="preview" class="border rounded"></iframe>
</div>



<script>
  // Initialize CodeMirror Editor
  var editor = CodeMirror.fromTextArea(document.getElementById("codeEditor"), {
    mode: "htmlmixed",
    theme: "dracula",
    lineNumbers: true,
    autoCloseTags: true,
    autoCloseBrackets: true,
  });

  // Function to update preview in real-time
  function updatePreview() {
    let preview = document.getElementById("preview").contentWindow.document;
    preview.open();
    preview.write(editor.getValue());
    preview.close();
  }

  // Update preview whenever text changes
  editor.on("change", updatePreview);

  // Initialize preview with current content
  updatePreview();

  // Save customized HTML via AJAX
  document.getElementById("saveBtn").addEventListener("click", function() {
    let content = editor.getValue(); // Get editor content
    let siteUrl = window.location.origin + window.location.pathname;
    let baseUrl = siteUrl.substring(0, siteUrl.lastIndexOf('/'));
    let apiUrl = baseUrl + '/?app_route=save_suspension_page'; // Ensure this is correctly routed

    console.log("Base URL:", apiUrl); // Debugging

    fetch(apiUrl, {
        method: "POST",
        headers: {
          'Content-Type': 'application/json',
        },
        body: JSON.stringify({
          content: content
        }) // Convert content to JSON
      })
      .then(response => {
        if (!response.ok) throw new Error('Network response was not ok');
        return response.json();
      })
      .then(data => {
        if (data.status === 'error') throw new Error(data.message);
        console.log("Success:", data);

        Swal.fire({
          icon: 'success',
          title: 'Changes Saved!',
          text: 'Your changes have been saved successfully.',
          timer: 1500,
          showConfirmButton: false,
          position: 'top-end',
          toast: true,
          customClass: {
            popup: 'swal-custom'
          }
        });

        updatePreview(); // Call update function after saving
      })
      .catch(error => {
        console.error("Error:", error);

        Swal.fire({
          icon: 'error',
          title: 'Error!',
          text: 'There was an error saving your changes. ' + error.message,
          timer: 1500,
          showConfirmButton: false,
          position: 'top-end',
          toast: true,
          customClass: {
            popup: 'swal-custom'
          }
        });
      });
  });
</script>

<?php include realpath(dirname(__DIR__) . '/include/footer.php'); ?>