<?php
include dirname(__DIR__) . '../include/check_installation.php';
include dirname(__DIR__) . '../include/auth_header.php';
?>
<style>
    #terminal {
        background: black;
        padding: 10px;
        border: 2px solid limegreen;
        height: 400px;
        overflow-y: auto;
    }

    .command {
        color: white;
    }

    .success {
        color: limegreen;
    }

    .error {
        color: red;
    }
</style>
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card overflow-hidden">
                <div class="bg-primary bg-soft">
                    <div class="row">
                        <div class="col-7">
                            <div class="text-primary p-4">
                                <h5 class="text-primary">Welcome Back to NuxSaaS !</h5>
                                <p>Sign in to continue to NuxSaaS.</p>
                            </div>
                        </div>
                        <div class="col-5 align-self-end">
                            <img src="assets/images/profile-img.png" alt="" class="img-fluid">
                        </div>
                    </div>
                </div>
                <div class="card-body pt-0">
                    <h2>Live Update Terminal</h2>
                    <div id="terminal"></div>
                    <button id="startUpdate">Start Update</button>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script>
    $(document).ready(function() {
        $("#startUpdate").click(function() {
            $("#terminal").html("<p class='command'>Starting update...</p>");
            runUpdate();
        });

        function runUpdate() {
            $.ajax({
                url: "update_process.php",
                method: "GET",
                dataType: "json",
                success: function(response) {
                    response.forEach(line => {
                        $("#terminal").append("<p class='" + line.type + "'>" + line.message + "</p>");
                        $("#terminal").scrollTop($("#terminal")[0].scrollHeight);
                    });
                },
                error: function() {
                    $("#terminal").append("<p class='error'>Error running update</p>");
                }
            });
        }
    });
</script>
<?php
include dirname(__DIR__) . '../include/auth_footer.php';
?>