<?php 
// Include function helper and check if system is already installed
$path = realpath(dirname(__DIR__) . '/include/function.php');
if ($path) {
    include $path;
    
    // Check if system is already installed
    if (isSystemInstalled()) {
        header('Location: ?app_route=login');
        exit;
    }
}

include 'app/include/pre_install_header.php'; ?>

<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <!-- Welcome Hero Section -->
            <div class="card border-0 shadow-lg">
                <div class="card-body text-center py-5">
                    <div class="mb-4">
                        <img src="public/assets/images/coming-soon.svg" alt="Welcome" style="max-width: 200px; height: auto;">
                    </div>
                    
                    <h1 class="display-4 text-primary mb-3">
                        <i class="mdi mdi-rocket-launch-outline"></i>
                        Welcome to NuxSaaS
                    </h1>
                    
                    <p class="lead text-muted mb-4">
                        Your comprehensive ISP management and automated subdomain creation platform
                    </p>
                    
                    <div class="row justify-content-center">
                        <div class="col-md-8">
                            <p class="text-muted">
                                NuxSaaS is a powerful platform designed to streamline ISP operations with automated account management, 
                                billing integration, and seamless subdomain creation for your customers.
                            </p>
                        </div>
                    </div>
                    
                    <div class="mt-4">
                        <a href="?app_route=dependency_check" class="btn btn-primary btn-lg me-3">
                            <i class="mdi mdi-shield-check"></i> Check System Requirements
                        </a>
                        <a href="?app_route=install" class="btn btn-outline-success btn-lg">
                            <i class="mdi mdi-download"></i> Start Installation
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- Features Section -->
            <div class="row mt-5">
                <div class="col-12">
                    <h2 class="text-center mb-4">Key Features</h2>
                </div>
            </div>
            
            <div class="row">
                <div class="col-lg-4 col-md-6 mb-4">
                    <div class="card h-100">
                        <div class="card-body text-center">
                            <div class="mb-3">
                                <i class="mdi mdi-account-multiple-plus-outline text-primary" style="font-size: 3rem;"></i>
                            </div>
                            <h5 class="card-title">Automated Account Management</h5>
                            <p class="card-text text-muted">
                                Streamline customer account creation, suspension, and renewal processes with full automation.
                            </p>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-6 mb-4">
                    <div class="card h-100">
                        <div class="card-body text-center">
                            <div class="mb-3">
                                <i class="mdi mdi-web text-success" style="font-size: 3rem;"></i>
                            </div>
                            <h5 class="card-title">Subdomain Creation</h5>
                            <p class="card-text text-muted">
                                Automatically create and manage subdomains for your customers with seamless DNS integration.
                            </p>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-6 mb-4">
                    <div class="card h-100">
                        <div class="card-body text-center">
                            <div class="mb-3">
                                <i class="mdi mdi-cash-multiple text-warning" style="font-size: 3rem;"></i>
                            </div>
                            <h5 class="card-title">Billing Integration</h5>
                            <p class="card-text text-muted">
                                Connect with PhpNuxBill for comprehensive billing and subscription management.
                            </p>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-6 mb-4">
                    <div class="card h-100">
                        <div class="card-body text-center">
                            <div class="mb-3">
                                <i class="mdi mdi-email-outline text-info" style="font-size: 3rem;"></i>
                            </div>
                            <h5 class="card-title">Email & SMS Notifications</h5>
                            <p class="card-text text-muted">
                                Keep customers informed with automated email and SMS notifications for all account activities.
                            </p>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-6 mb-4">
                    <div class="card h-100">
                        <div class="card-body text-center">
                            <div class="mb-3">
                                <i class="mdi mdi-cog-outline text-secondary" style="font-size: 3rem;"></i>
                            </div>
                            <h5 class="card-title">Easy Configuration</h5>
                            <p class="card-text text-muted">
                                Simple web-based configuration interface for all system settings and integrations.
                            </p>
                        </div>
                    </div>
                </div>
                
                <div class="col-lg-4 col-md-6 mb-4">
                    <div class="card h-100">
                        <div class="card-body text-center">
                            <div class="mb-3">
                                <i class="mdi mdi-shield-check-outline text-danger" style="font-size: 3rem;"></i>
                            </div>
                            <h5 class="card-title">Secure & Reliable</h5>
                            <p class="card-text text-muted">
                                Built with security best practices and reliable infrastructure for ISP operations.
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Requirements Section -->
            <div class="row mt-5">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header bg-light">
                            <h4 class="card-title mb-0">
                                <i class="mdi mdi-information-outline"></i>
                                System Requirements
                            </h4>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h6><strong>Server Requirements:</strong></h6>
                                    <ul class="list-unstyled">
                                        <li><i class="mdi mdi-check text-success"></i> PHP 7.4 or higher</li>
                                        <li><i class="mdi mdi-check text-success"></i> MySQL 5.7 or higher</li>
                                        <li><i class="mdi mdi-check text-success"></i> Apache/Nginx web server</li>
                                        <li><i class="mdi mdi-check text-success"></i> SSL certificate (recommended)</li>
                                    </ul>
                                </div>
                                <div class="col-md-6">
                                    <h6><strong>PHP Extensions:</strong></h6>
                                    <ul class="list-unstyled">
                                        <li><i class="mdi mdi-check text-success"></i> mysqli (MySQL support)</li>
                                        <li><i class="mdi mdi-check text-success"></i> curl (HTTP requests)</li>
                                        <li><i class="mdi mdi-check text-success"></i> json (JSON processing)</li>
                                        <li><i class="mdi mdi-check text-success"></i> mbstring (String functions)</li>
                                        <li><i class="mdi mdi-check text-success"></i> openssl (SSL support)</li>
                                        <li><i class="mdi mdi-check text-success"></i> zip (Archive support)</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Getting Started Section -->
            <div class="row mt-5 mb-5">
                <div class="col-12">
                    <div class="card border-primary">
                        <div class="card-header bg-primary text-white">
                            <h4 class="card-title mb-0 text-white">
                                <i class="mdi mdi-rocket-launch"></i>
                                Ready to Get Started?
                            </h4>
                        </div>
                        <div class="card-body">
                            <p class="card-text">
                                Follow these simple steps to set up your NuxSaaS platform:
                            </p>
                            
                            <div class="row">
                                <div class="col-md-4 text-center mb-3">
                                    <div class="mb-3">
                                        <span class="badge bg-primary rounded-circle p-3" style="font-size: 1.5rem;">1</span>
                                    </div>
                                    <h6>Check Requirements</h6>
                                    <p class="text-muted">Verify your system meets all requirements</p>
                                </div>
                                
                                <div class="col-md-4 text-center mb-3">
                                    <div class="mb-3">
                                        <span class="badge bg-primary rounded-circle p-3" style="font-size: 1.5rem;">2</span>
                                    </div>
                                    <h6>Run Installation</h6>
                                    <p class="text-muted">Complete the guided installation process</p>
                                </div>
                                
                                <div class="col-md-4 text-center mb-3">
                                    <div class="mb-3">
                                        <span class="badge bg-primary rounded-circle p-3" style="font-size: 1.5rem;">3</span>
                                    </div>
                                    <h6>Configure Settings</h6>
                                    <p class="text-muted">Set up your preferences and integrations</p>
                                </div>
                            </div>
                            
                            <div class="text-center mt-4">
                                <a href="?app_route=dependency_check" class="btn btn-primary btn-lg me-3">
                                    <i class="mdi mdi-play"></i> Start Setup Process
                                </a>
                                <a href="#" class="btn btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#helpModal">
                                    <i class="mdi mdi-help-circle"></i> Need Help?
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Help Modal -->
<div class="modal fade" id="helpModal" tabindex="-1" aria-labelledby="helpModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="helpModalLabel">
                    <i class="mdi mdi-help-circle"></i> Need Help?
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <h6>Common Issues & Solutions:</h6>
                
                <div class="accordion" id="helpAccordion">
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne">
                                PHP Version Issues
                            </button>
                        </h2>
                        <div id="collapseOne" class="accordion-collapse collapse show" data-bs-parent="#helpAccordion">
                            <div class="accordion-body">
                                <p>If your PHP version is too old:</p>
                                <ul>
                                    <li>Contact your hosting provider to upgrade PHP</li>
                                    <li>For local development, use XAMPP/WAMP with PHP 7.4+</li>
                                    <li>Check phpinfo() to verify the current version</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTwo">
                                Missing PHP Extensions
                            </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#helpAccordion">
                            <div class="accordion-body">
                                <p>To install missing extensions:</p>
                                <ul>
                                    <li><strong>Ubuntu/Debian:</strong> <code>sudo apt-get install php-extension-name</code></li>
                                    <li><strong>CentOS/RHEL:</strong> <code>sudo yum install php-extension-name</code></li>
                                    <li><strong>Windows/XAMPP:</strong> Enable in php.ini file</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                    
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingThree">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree">
                                Permission Issues
                            </button>
                        </h2>
                        <div id="collapseThree" class="accordion-collapse collapse" data-bs-parent="#helpAccordion">
                            <div class="accordion-body">
                                <p>To fix file permissions:</p>
                                <ul>
                                    <li><strong>Linux:</strong> <code>chmod 755 directories && chmod 644 files</code></li>
                                    <li><strong>Web directories:</strong> Usually need 755 permissions</li>
                                    <li><strong>Config files:</strong> Usually need 644 permissions</li>
                                    <li>Ensure web server can read/write to required directories</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="mt-4">
                    <h6>Still Need Help?</h6>
                    <p>Contact support or check the documentation for more detailed instructions.</p>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<?php include 'app/include/pre_install_footer.php'; ?>
