<?php
namespace Core;

class Redirect {

    // Start the session if not already started
    public static function startSession() {
        if (session_status() == PHP_SESSION_NONE) {
            session_start();
        }
    }

    // Store a success message in session
    public static function redirectSuccess($page_name, $message) {
        self::startSession();
        $_SESSION['success'] = $message;  // Store success message in session
        header('Location: ?app_route=' . $page_name);
        exit();
    }

    // Store an error message in session
    public static function redirectError($page_name, $message) {
        self::startSession();
        $_SESSION['error'] = $message;  // Store error message in session
        header('Location: ?app_route=' . $page_name);
        exit();
    }
}
?>
