# INSTALLATION GUIDE FOR NUXSAAS

This guide will help you install NuxSaas on your server. NuxSaas is a SaaS platform based on Phpnuxbill, designed for easy management of SaaS applications.

## Overview
NuxSaas is a comprehensive ISP management platform with automated subdomain creation capabilities, designed to streamline ISP operations and enhance customer management.

## Features
- **Automated Account Management**: Streamline customer account creation, suspension, and renewal
- **Subdomain Creation**: Automatically create and manage subdomains for customers
- **Billing Integration**: Connect with PhpNuxBill for comprehensive billing management
- **Email & SMS Notifications**: Automated notifications for all account activities
- **Easy Configuration**: Web-based configuration interface
- **Secure & Reliable**: Built with security best practices

### Server Requirements
- PHP 7.4 or higher
- VPS or Dedicated server
- MySQL 5.7 or higher
- Apache/Nginx web server
- SSL certificate (recommended)
- Cloudflare Account
- Domain name

### lAMP AND LEMP Stack Inastallation manual

- **LAMP**: Linux, Apache, MySQL, PHP [How to install LAMP stack on Ubuntu](https://github.com/alvin-kiveu/TECHBLOG/blob/main/Steps-to-Set-Up-PHP-Apache-MySQL-and-phpMyAdmin-on-Ubuntu.md)

- **LEMP**: Linux, Nginx, MySQL, PHP [How to install LEMP stack on Ubuntu](https://github.com/alvin-kiveu/TECHBLOG/blob/main/Steps-to-Set-Up-PHP-Nginx-MySQL-and-phpMyAdmin-on-Ubuntu.md)

After installing the LAMP or LEMP stack, you can proceed with the NuxSaas installation.

1. Buy and download the latest version from [https://alvinkiveu.com/script/nuxsaas-for-phpnuxbill](https://alvinkiveu.com/script/nuxsaas-for-phpnuxbill) and unzip the files.
2. Rename the folder to `nuxsaas`.
3. Upload the folder to your server using SFTP or SSH to the directory `/var/www/html/`
4. Unzip the file:

```bash
cd /var/www/html/
sudo unzip nuxsaas.zip
```

5. Change ownership and permissions:

```bash
sudo chown -R www-data:www-data /var/www/html/ && sudo chmod -R 755 /var/www/html/
sudo chown -R www-data:www-data /var/www/html/amazons/ && sudo chmod -R 755 /var/www/html/amazons/
```

for apache 

```bash
sudo chown -R www-data:www-data /etc/apache2/sites-available/ && sudo chmod -R 755 /etc/apache2/sites-available/
```

for nginx

```bash
sudo chown -R www-data:www-data /etc/nginx/sites-available/ && sudo chmod -R 755 /etc/nginx/sites-available/
```



6. Log in to Cloudflare and add the domain name for your NuxSaas app:
    - Add the domain to your Cloudflare account
    - Change your domain's nameservers to the ones provided by Cloudflare
    - Wait for the DNS to propagate (status should change to active)
    - Add A record:

        - **If using a subdomain:**
            - Type: A
            - Name: `nuxsaas`
            - IPv4: your server IP
            - TTL: Auto
            - Proxy status: DNS only
        
        - **If using full domain:**
            - Type: A
            - Name: `@`
            - IPv4: your server IP
            - TTL: Auto
            - Proxy status: DNS only

### 📌 Notes:
- **Cloudflare Token:** Go to your Cloudflare dashboard → My Profile → API Tokens → Create Token. Choose template or custom permissions (Zone.Zone, Zone.DNS, Zone.Cache Purge).
- **Cloudflare Zone ID:** Go to the domain overview in Cloudflare. You'll find the Zone ID at the bottom of the page.

7. Add the domain to your server:

for Apache:
http://app.sebitnetworks.com

```bash
sudo nano /etc/apache2/sites-available/app.sebitnetworks.com.conf
```

8. Add the following config (replace `example.com` with your domain):

```apache
<VirtualHost *:80>
    ServerName app.sebitnetworks.com
    ServerAdmin mail@app.sebitnetworks.com
    DocumentRoot /var/www/html/nuxsaas

    <Directory /var/www/html/nuxsaas/>
        Options Indexes FollowSymLinks
        AllowOverride All
        Require all granted
    </Directory>

    ErrorLog ${APACHE_LOG_DIR}/error.log
    CustomLog ${APACHE_LOG_DIR}/access.log combined

    <IfModule mod_dir.c>
        DirectoryIndex index.html index.php
    </IfModule>
</VirtualHost>
```


9. Enable site and required modules:

```bash
sudo a2ensite app.sebitnetworks.com.conf
systemctl reload apache2
sudo a2enmod rewrite
```

10. Restart Apache:

```bash
sudo systemctl restart apache2
```

11. Check configuration:

```bash


# Should output: Syntax OK
```

12. Optional: Allow `www-data` to reload Apache without password:

```bash
sudo visudo
# Add this line at the end:
www-data ALL=(ALL) NOPASSWD: /usr/sbin/a2ensite, /bin/systemctl reload apache2, /usr/bin/certbot
```

give ssl permission to the domain:

```bash
sudo certbot --apache -d cloudwifi.trymysoftware.online
```

13. Open your browser and visit the domain you added (e.g., `https://nuxsaas.mikrol.ink`).




## NuxSaas Installation

1. Go to your domain in the browser
2. Fill in the installation form and click Install
3. If successful, you’ll see “Installation Successful”
4. If not, fix the displayed errors and try again

**Default login credentials:**
```
username: admin
password: admin
```

### 📌 Notes:
- **Telegram Bot Token:** Create a bot using BotFather on Telegram. After creating, you'll receive the token.
- **Telegram Chat ID:**
    1. Send a message to your bot
    2. Visit: `https://api.telegram.org/bot<YOUR_BOT_TOKEN>/getUpdates`
    3. Look for `chat.id` in the response JSON (e.g., `chat":{"id":123456789,...}`)

