
cd /var/www/html/

mkdir trymysoftware

nano trymysoftware/index.php

```php
<?php
echo "Welcome to TryMySoftware!";
?>
```

Create Apache configuration file for the new domain:

```bash
sudo nano /etc/apache2/sites-available/trymysoftware.online.conf
```



```apache
<VirtualHost *:80>
    ServerName trymysoftware.online
    ServerAdmin mail@nuxsaas.trymysoftware.online
    DocumentRoot /var/www/html/trymysoftware

    <Directory /var/www/html/trymysoftware/>
        Options Indexes FollowSymLinks
        AllowOverride All
        Require all granted
    </Directory>

    ErrorLog ${APACHE_LOG_DIR}/error.log
    CustomLog ${APACHE_LOG_DIR}/access.log combined

    <IfModule mod_dir.c>
        DirectoryIndex index.html index.php
    </IfModule>
</VirtualHost>
```

giveSubdomainSSLPermission



8. Enable the site and required modules:

```bash
sudo a2ensite trymysoftware.online.conf
sudo a2enmod rewrite
sudo systemctl restart apache2  
```


9. Check the Apache configuration:

```bash
sudo apache2ctl configtest
# Should output: Syntax OK
```

give ssl permission to the domain:

```bash
sudo certbot --apache -d trymysoftware.online
```


5. Change ownership and permissions:

```bash
sudo chown -R www-data:www-data /var/www/html/trymysoftware/ && sudo chmod -R 755 /var/www/html/trymysoftware/
```

```bash
sudo systemctl restart apache2  
```