# AllxSys - Internet Management System

[![Version](https://img.shields.io/badge/version-1.0.0-blue.svg)](version.json)
[![License](https://img.shields.io/badge/license-MIT-green.svg)](LICENSE)
[![Kenya](https://img.shields.io/badge/market-Kenya-red.svg)](#kenya-features)

**AllxSys** is a comprehensive Internet Service Provider (ISP) management system designed specifically for the Kenyan market. It provides complete hotspot management, customer billing, and payment processing with built-in M-Pesa integration.

## ✨ Key Features

### 🚀 Core Functionality
- **Hotspot Management**: Complete WiFi hotspot solution with captive portal
- **Customer Management**: Comprehensive user account management
- **Billing System**: Automated billing with multiple payment methods
- **Voucher System**: Generate and manage internet vouchers
- **Bandwidth Control**: Advanced QoS and bandwidth management
- **Reports & Analytics**: Detailed financial and usage reports

### 🇰🇪 Kenya-Specific Features
- **M-Pesa Integration**: Native M-Pesa payment processing
- **KES Currency Support**: Kenya Shillings with proper formatting
- **EAT Timezone**: East Africa Time (UTC+3) support
- **Local Phone Validation**: Kenyan phone number formats
- **Regulatory Compliance**: Meets Kenya's ISP requirements

### 🔐 Advanced Permission System
- **47 Granular Permissions** across 5 categories
- **Role-Based Access Control** (RBAC)
- **Individual Permission Override** capabilities
- **6 Built-in User Roles** with customizable permissions
- **Hierarchical Permission Structure**

### 📱 Modern Interface
- **Responsive Design**: Mobile-first approach
- **TailwindCSS Styling**: Modern, clean interface
- **Real-time Updates**: Live dashboard with auto-refresh
- **Multi-language Support**: Extensible language system

## 🛠️ Technical Specifications

### System Requirements
- **PHP**: 7.4+ (Recommended: PHP 8.1+)
- **Database**: MySQL 5.7+ or MariaDB 10.3+
- **Web Server**: Apache 2.4+ or Nginx 1.18+
- **Memory**: Minimum 512MB RAM (Recommended: 1GB+)
- **Storage**: 2GB+ available disk space

### Supported Devices
- **MikroTik RouterOS**: All versions with API support
- **Ubiquiti UniFi**: Controller-based management
- **pfSense/OPNsense**: Captive portal integration
- **Generic RADIUS**: Standard RADIUS protocol support

## 🚀 Quick Installation

### 1. Download & Extract
```bash
git clone https://github.com/yourusername/allxsys.git
cd allxsys
```

### 2. Database Setup
```sql
CREATE DATABASE allxsys CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;
mysql -u root -p allxsys < allxsys_clean_database.sql
```

### 3. Configuration
```bash
cp config.sample.php config.php
# Edit config.php with your database settings
```

### 4. Create SuperAdmin
```sql
INSERT INTO tbl_users (username, fullname, password, phone, email, city, subdistrict, ward, user_type, status, creationdate, root) 
VALUES ('admin', 'Administrator', MD5('admin123'), '+254700000000', 'admin@allxsys.co.ke', 'Nairobi', 'Nairobi Central', 'CBD', 'SuperAdmin', 'Active', NOW(), 1);
```

### 5. Access System
- URL: `http://your-domain.com`
- Username: `admin`
- Password: `admin123` (Change immediately!)

For detailed installation instructions, see [ALLXSYS_INSTALLATION_GUIDE.md](ALLXSYS_INSTALLATION_GUIDE.md)

## 📋 Permission System Overview

### Permission Categories
| Category | Description | Count |
|----------|-------------|--------|
| **Pages** | Access to system sections | 14 |
| **Functions** | Specific actions (CRUD operations) | 16 |
| **Widgets** | Dashboard widget visibility | 6 |
| **Settings** | Configuration access | 7 |
| **Data** | Advanced data access | 4 |

### User Roles
| Role | Description | Default Permissions |
|------|-------------|-------------------|
| **SuperAdmin** | Full system access | All permissions (unrestricted) |
| **Admin** | Management functions | Most operational permissions |
| **Report** | Reporting & analytics | Read-only access to reports |
| **Agent** | Customer service | Customer management & recharging |
| **Sales** | Sales operations | Limited customer & voucher creation |
| **Viewer** | Read-only access | Basic information viewing |

## 💰 Payment Integration

### M-Pesa Configuration
```php
// M-Pesa settings in system configuration
'mpesa_consumer_key' => 'your_consumer_key',
'mpesa_consumer_secret' => 'your_consumer_secret',
'mpesa_shortcode' => 'your_shortcode',
'mpesa_passkey' => 'your_passkey',
'mpesa_environment' => 'live', // or 'sandbox'
```

### Supported Payment Methods
- **M-Pesa**: STK Push, C2B payments
- **Bank Transfer**: Manual verification
- **Cash**: Physical payment tracking
- **Vouchers**: Prepaid voucher system
- **Credit**: Account balance system

## 📊 Dashboard Features

### Real-time Widgets
- **Revenue Overview**: Daily, weekly, monthly income
- **Customer Statistics**: Active, expired, new customers
- **Bandwidth Usage**: Network utilization graphs
- **Online Users**: Currently connected users
- **Recent Transactions**: Latest payment activities
- **System Status**: Server and service health

### Customizable Interface
- Drag-and-drop widget arrangement
- Role-based widget visibility
- Custom dashboard layouts per user type
- Responsive design for all devices

## 🔧 Configuration Options

### Localization Settings
```php
// Kenya-specific configurations
'timezone' => 'Africa/Nairobi',
'currency_code' => 'KES',
'currency_symbol' => 'KSh',
'date_format' => 'd/m/Y',
'phone_country_code' => '+254',
```

### Network Settings
```php
// Router and network configuration
'radius_server' => '127.0.0.1',
'radius_secret' => 'your_radius_secret',
'hotspot_name' => 'AllxSys Hotspot',
'session_timeout' => 3600,
```

## 📈 Performance & Scalability

### Optimizations
- **Database Indexing**: Optimized queries for large datasets
- **Connection Pooling**: Efficient database connection management
- **Caching**: Redis/Memcached support for session storage
- **CDN Ready**: Asset optimization for content delivery

### Monitoring
- **System Logs**: Comprehensive activity logging
- **Error Tracking**: Detailed error reporting
- **Performance Metrics**: Response time monitoring
- **Health Checks**: Automated system health verification

## 🛡️ Security Features

### Authentication & Authorization
- **Secure Password Hashing**: bcrypt/Argon2 support
- **Session Management**: Secure session handling
- **CSRF Protection**: Cross-site request forgery prevention
- **SQL Injection Prevention**: Parameterized queries

### Data Protection
- **Data Encryption**: Sensitive data encryption at rest
- **Audit Trails**: Complete activity logging
- **Backup Systems**: Automated database backups
- **GDPR Compliance**: Data protection compliance tools

## 📚 Documentation

- [Installation Guide](ALLXSYS_INSTALLATION_GUIDE.md)
- [Permission System Documentation](PERMISSION_SYSTEM_DOCUMENTATION.md)
- [API Documentation](docs/api.md)
- [Configuration Reference](docs/configuration.md)
- [Troubleshooting Guide](docs/troubleshooting.md)

## 🤝 Contributing

We welcome contributions to AllxSys! Please read our contributing guidelines:

1. Fork the repository
2. Create a feature branch
3. Make your changes
4. Add tests if applicable
5. Submit a pull request

### Development Setup
```bash
# Clone repository
git clone https://github.com/yourusername/allxsys.git

# Install dependencies
composer install

# Set up development environment
cp config.sample.php config.dev.php
# Configure development settings
```

## 📄 License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

## 🆘 Support

### Community Support
- **GitHub Issues**: [Report bugs or request features](https://github.com/yourusername/allxsys/issues)
- **Discussions**: [Community forum](https://github.com/yourusername/allxsys/discussions)
- **Documentation**: [Wiki pages](https://github.com/yourusername/allxsys/wiki)

### Professional Support
For enterprise support, custom development, or consulting services, contact:
- Email: support@allxsys.co.ke
- Phone: +254 700 000 000

## 🏆 Acknowledgments

- Based on modern PHP practices and frameworks
- Inspired by the needs of Kenyan ISP operators
- Built with community feedback and contributions
- Designed for African market requirements

## 📅 Release Information

- **Current Version**: 1.0.0
- **Release Date**: March 2025
- **Build**: 2025.3.20
- **Target Market**: Kenya
- **Stability**: Production Ready

---

**AllxSys** - Empowering Internet Service Providers in Kenya 🇰🇪

For the latest updates and announcements, follow our [GitHub releases](https://github.com/yourusername/allxsys/releases).