<?php

include __DIR__ . "/../init.php";
$lockFile = "$CACHE_PATH/router_monitor.lock";

if (!is_dir($CACHE_PATH)) {
    echo "Directory '$CACHE_PATH' does not exist. Exiting...\n";
    exit;
}

// Record system start date on first cron run
$systemStartConfig = ORM::for_table('tbl_appconfig')->where('setting', 'system_start_date')->find_one();
if (!$systemStartConfig) {
    $systemStartConfig = ORM::for_table('tbl_appconfig')->create();
    $systemStartConfig->setting = 'system_start_date';
    $systemStartConfig->value = date('Y-m-d H:i:s');
    $systemStartConfig->save();
    echo "System start date recorded: " . date('Y-m-d H:i:s') . "\n";
}

$lock = fopen($lockFile, 'c');

if ($lock === false) {
    echo "Failed to open lock file. Exiting...\n";
    exit;
}

if (!flock($lock, LOCK_EX | LOCK_NB)) {
    echo "Script is already running. Exiting...\n";
    fclose($lock);
    exit;
}


$isCli = true;
if (php_sapi_name() !== 'cli') {
    $isCli = false;
    echo "<pre>";
}
echo "PHP Time\t" . date('Y-m-d H:i:s') . "\n";
$res = ORM::raw_execute('SELECT NOW() AS WAKTU;');
$statement = ORM::get_last_statement();
$rows = [];
while ($row = $statement->fetch(PDO::FETCH_ASSOC)) {
    echo "MYSQL Time\t" . $row['WAKTU'] . "\n";
}

$_c = $config;


$textExpired = Lang::getNotifText('expired');

$d = ORM::for_table('tbl_user_recharges')->where('status', 'on')->where_lte('expiration', date("Y-m-d"))->find_many();
echo "Found " . count($d) . " user(s)\n";
run_hook('cronjob'); #HOOK

// === MIKROTIK USAGE MONITORING INTEGRATION ===
// Enhanced version: Uses proven MikroTik Monitor approach for data collection
// Saves live data to local database for customer usage analytics
echo "=== Starting MikroTik Usage Monitor ===\n";

// --- Create required database tables ---
function createUsageTablesIfNeeded() {
    try {
        $db = ORM::get_db();
        
        // Create tbl_usage_sessions table (tracks active sessions)
        $sessionTableExists = $db->query("SHOW TABLES LIKE 'tbl_usage_sessions'")->fetch();
        if (!$sessionTableExists) {
            $sessionTableSQL = "CREATE TABLE `tbl_usage_sessions` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `router_id` int(11) NOT NULL,
              `username` varchar(64) NOT NULL,
              `interface` varchar(20) NOT NULL DEFAULT 'hotspot',
              `session_id` varchar(64) NOT NULL,
              `ip_address` varchar(45) DEFAULT NULL,
              `mac_address` varchar(17) DEFAULT NULL,
              `last_rx` bigint(20) DEFAULT 0,
              `last_tx` bigint(20) DEFAULT 0,
              `session_rx` bigint(20) DEFAULT 0,
              `session_tx` bigint(20) DEFAULT 0,
              `start_time` datetime NOT NULL,
              `last_seen` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
              PRIMARY KEY (`id`),
              UNIQUE KEY `unique_session` (`router_id`,`username`,`session_id`),
              KEY `idx_router_username` (`router_id`,`username`),
              KEY `idx_last_seen` (`last_seen`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci";
            
            $db->exec($sessionTableSQL);
            echo "Created table: tbl_usage_sessions\n";
        }
        
        // Create tbl_usage_records table (cumulative usage data)
        $recordsTableExists = $db->query("SHOW TABLES LIKE 'tbl_usage_records'")->fetch();
        if (!$recordsTableExists) {
            $recordsTableSQL = "CREATE TABLE `tbl_usage_records` (
              `id` int(11) NOT NULL AUTO_INCREMENT,
              `router_id` int(11) NOT NULL,
              `username` varchar(64) NOT NULL,
              `interface` varchar(20) NOT NULL DEFAULT 'hotspot',
              `tx_bytes` bigint(20) DEFAULT 0,
              `rx_bytes` bigint(20) DEFAULT 0,
              `last_seen` datetime NOT NULL,
              `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
              `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
              PRIMARY KEY (`id`),
              UNIQUE KEY `unique_user_router` (`router_id`,`username`,`interface`),
              KEY `idx_username` (`username`),
              KEY `idx_last_seen` (`last_seen`),
              KEY `idx_router` (`router_id`)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci";
            
            $db->exec($recordsTableSQL);
            echo "Created table: tbl_usage_records\n";
        }
        
        return true;
    } catch (Exception $e) {
        echo "Error creating usage tables: " . $e->getMessage() . "\n";
        return false;
    }
}

// --- Format bytes function (from mikrotik_monitor.php) ---
function formatUsageBytes($bytes, $precision = 2) {
    $units = ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];
    $bytes = max($bytes, 0);
    $pow = floor(($bytes ? log($bytes) : 0) / log(1024));
    $pow = min($pow, count($units) - 1);
    $bytes /= pow(1024, $pow);
    return round($bytes, $precision) . ' ' . $units[$pow];
}

// --- Function to process user sessions and update database ---
function processUserSession($router_id, $username, $interface, $session_id, $current_rx, $current_tx, $now, $ip_address = null, $mac_address = null) {
    try {
        // Find existing session record
        $session = ORM::for_table('tbl_usage_sessions')
            ->where('router_id', $router_id)
            ->where('username', $username)
            ->where('session_id', $session_id)
            ->find_one();

        $inc_rx = 0;
        $inc_tx = 0;

        if ($session) {
            // Since we clear all sessions first, this should rarely happen
            // But handle it for safety - calculate incremental usage
            $inc_rx = max(0, $current_rx - $session->last_rx);
            $inc_tx = max(0, $current_tx - $session->last_tx);

            // Update session counters
            $session->last_rx = $current_rx;
            $session->last_tx = $current_tx;
            $session->session_rx += $inc_rx;
            $session->session_tx += $inc_tx;
            $session->last_seen = $now;
            // Update IP and MAC if provided (validate and sanitize)
            if ($ip_address !== null && filter_var($ip_address, FILTER_VALIDATE_IP)) {
                $session->ip_address = $ip_address;
            }
            if ($mac_address !== null && preg_match('/^[0-9A-Fa-f]{2}[:-][0-9A-Fa-f]{2}[:-][0-9A-Fa-f]{2}[:-][0-9A-Fa-f]{2}[:-][0-9A-Fa-f]{2}[:-][0-9A-Fa-f]{2}$/', $mac_address)) {
                $session->mac_address = strtoupper($mac_address);
            }
            $session->save();

            echo "    SESSION UPDATE: {$username} | +RX: " . formatUsageBytes($inc_rx) . " +TX: " . formatUsageBytes($inc_tx) . "\n";
        } else {
            // New session - create record
            // For new sessions, we treat the current MikroTik data as incremental (since it's a fresh session)
            $inc_rx = $current_rx;  // Full current data is new for this session
            $inc_tx = $current_tx;  // Full current data is new for this session
            
            $session = ORM::for_table('tbl_usage_sessions')->create();
            $session->router_id = $router_id;
            $session->username = $username;
            $session->interface = $interface;
            $session->session_id = $session_id;
            // Validate and store IP and MAC addresses
            if ($ip_address !== null && filter_var($ip_address, FILTER_VALIDATE_IP)) {
                $session->ip_address = $ip_address;
            }
            if ($mac_address !== null && preg_match('/^[0-9A-Fa-f]{2}[:-][0-9A-Fa-f]{2}[:-][0-9A-Fa-f]{2}[:-][0-9A-Fa-f]{2}[:-][0-9A-Fa-f]{2}[:-][0-9A-Fa-f]{2}$/', $mac_address)) {
                $session->mac_address = strtoupper($mac_address);
            }
            $session->last_rx = $current_rx;
            $session->last_tx = $current_tx;
            // Store current MikroTik session data (shows what user has used in THIS session)
            $session->session_rx = $current_rx;  // Current session usage
            $session->session_tx = $current_tx;  // Current session usage
            $session->start_time = $now;
            $session->last_seen = $now;
            $session->save();

            echo "    NEW SESSION: {$username} | Session Data: RX=" . formatUsageBytes($current_rx) . " TX=" . formatUsageBytes($current_tx) . "\n";
        }

        // Update cumulative usage record (for customer usage analytics)
        $rec = ORM::for_table('tbl_usage_records')
            ->where('router_id', $router_id)
            ->where('username', $username)
            ->where('interface', $interface)
            ->find_one();

        if ($rec) {
            // Add incremental usage to lifetime totals
            if ($inc_tx > 0 || $inc_rx > 0) {
                $old_tx = $rec->tx_bytes;
                $old_rx = $rec->rx_bytes;
                $rec->tx_bytes += $inc_tx;
                $rec->rx_bytes += $inc_rx;
                $rec->last_seen = $now;
                $rec->save();
                
                echo "    USAGE RECORD: {$username} | Lifetime Total: RX=" . formatUsageBytes($rec->rx_bytes) . " TX=" . formatUsageBytes($rec->tx_bytes) . "\n";
            } else {
                // Update last_seen even if no new usage
                $rec->last_seen = $now;
                $rec->save();
            }
        } else {
            // Create new usage record
            $rec = ORM::for_table('tbl_usage_records')->create();
            $rec->router_id = $router_id;
            $rec->username = $username;
            $rec->interface = $interface;
            $rec->tx_bytes = $inc_tx;
            $rec->rx_bytes = $inc_rx;
            $rec->last_seen = $now;
            $rec->save();
            
            echo "    NEW USER RECORD: {$username} | Initial: RX=" . formatUsageBytes($inc_rx) . " TX=" . formatUsageBytes($inc_tx) . "\n";
        }

    } catch (Exception $e) {
        echo "    ERROR processing {$username}: " . $e->getMessage() . "\n";
    }
}

// Session cleanup is now handled by clearing all sessions per router at start of processing

// Ensure usage tables exist
if (!createUsageTablesIfNeeded()) {
    echo "Failed to create usage database tables - skipping usage monitoring\n";
} else {
    // --- Fetch all enabled routers for usage monitoring ---
    $usage_routers = ORM::for_table('tbl_routers')
        ->where('enabled', '1')
        ->find_many();
    echo "Found " . count($usage_routers) . " enabled router(s) for usage monitoring.\n";

    $now = date('Y-m-d H:i:s');
    
    // Get list of enabled router IDs for cleanup
    $enabled_router_ids = [];
    foreach ($usage_routers as $router) {
        $enabled_router_ids[] = $router->id;
    }

    foreach ($usage_routers as $router) {
        $rid = $router->id;
        echo "-- Usage Monitor Router {$rid} ({$router->ip_address}) --\n";
        
        try {
            $client = Mikrotik::getClient(
                $router->ip_address,
                $router->username,
                $router->password
            );
            echo "Connected to router successfully for usage monitoring\n";
        } catch (Exception $e) {
            echo "Usage monitoring connection failed: " . $e->getMessage() . "\n";
            continue;
        }

        // --- SMART CLEANUP: Mark sessions as inactive instead of deleting ---
        echo "Marking old sessions as inactive for router {$rid}...\n";
        // Mark sessions older than 2 minutes as potentially inactive
        $old_sessions = ORM::for_table('tbl_usage_sessions')
            ->where('router_id', $rid)
            ->where_lt('last_seen', date('Y-m-d H:i:s', strtotime('-2 minutes')))
            ->find_many();
        
        $inactive_count = count($old_sessions);
        foreach ($old_sessions as $session) {
            $session->delete(); // Remove truly old sessions
        }
        echo "Cleaned {$inactive_count} old sessions (older than 2 minutes)\n";
        
        // --- HOTSPOT USERS (Using MikroTik Monitor approach) ---
        try {
            echo "Fetching hotspot active users...\n";
            $hotspotActive = $client->sendSync(new PEAR2\Net\RouterOS\Request('/ip/hotspot/active/print'));
            $hotspotCount = count($hotspotActive);
            echo "Found {$hotspotCount} active hotspot users\n";

            foreach ($hotspotActive as $hotspot) {
                $username = $hotspot->getProperty('user');
                $address = $hotspot->getProperty('address');
                $uptime = $hotspot->getProperty('uptime');
                $server = $hotspot->getProperty('server');
                $mac = $hotspot->getProperty('mac-address');
                $session_id = $hotspot->getProperty('.id');  // Unique session ID
                
                // CRITICAL: Get usage data (like mikrotik_monitor.php)
                $rxBytes = intval($hotspot->getProperty('bytes-in'));    // Download
                $txBytes = intval($hotspot->getProperty('bytes-out'));   // Upload
                
                if ($username && $session_id) {
                    // Process session tracking with IP and MAC
                    processUserSession($rid, $username, 'hotspot', $session_id, $rxBytes, $txBytes, $now, $address, $mac);
                    echo "  HOTSPOT: {$username} ({$address}) [{$mac}] | RX: " . formatUsageBytes($rxBytes) . " TX: " . formatUsageBytes($txBytes) . "\n";
                }
            }
        } catch (Exception $e) {
            echo "Error fetching hotspot users: " . $e->getMessage() . "\n";
        }

        // --- PPPOE USERS (Using MikroTik Monitor approach) ---
        try {
            echo "Fetching PPPoE active users...\n";
            $pppUsers = $client->sendSync(new PEAR2\Net\RouterOS\Request('/ppp/active/print'));
            $pppCount = count($pppUsers);
            echo "Found {$pppCount} active PPPoE users\n";

            // Get interface data for PPPoE usage (like mikrotik_monitor.php)
            $interfaceTraffic = $client->sendSync(new PEAR2\Net\RouterOS\Request('/interface/print'));
            $interfaceData = [];
            foreach ($interfaceTraffic as $interface) {
                $name = $interface->getProperty('name');
                if (!empty($name)) {
                    $interfaceData[$name] = [
                        'txBytes' => intval($interface->getProperty('tx-byte')),
                        'rxBytes' => intval($interface->getProperty('rx-byte')),
                    ];
                }
            }

            foreach ($pppUsers as $pppUser) {
                $username = $pppUser->getProperty('name');
                $address = $pppUser->getProperty('address');
                $uptime = $pppUser->getProperty('uptime');
                $service = $pppUser->getProperty('service');
                $session_id = $pppUser->getProperty('.id');  // Unique session ID

                // Get usage from interface (like mikrotik_monitor.php)
                $interfaceName = "<pppoe-$username>";
                if (isset($interfaceData[$interfaceName])) {
                    $trafficData = $interfaceData[$interfaceName];
                    $txBytes = $trafficData['txBytes'];
                    $rxBytes = $trafficData['rxBytes'];
                } else {
                    $txBytes = 0;
                    $rxBytes = 0;
                }

                if ($username && $session_id) {
                    // Process session tracking with IP (no MAC for PPPoE)
                    processUserSession($rid, $username, 'pppoe', $session_id, $rxBytes, $txBytes, $now, $address, null);
                    echo "  PPPOE: {$username} ({$address}) | RX: " . formatUsageBytes($rxBytes) . " TX: " . formatUsageBytes($txBytes) . "\n";
                }
            }
        } catch (Exception $e) {
            echo "Error fetching PPPoE users: " . $e->getMessage() . "\n";
        }

        echo "Finished processing usage for router {$rid}\n";
    }
}

// --- Display recent session data with IP/MAC for verification ---
try {
    $recentSessions = ORM::for_table('tbl_usage_sessions')
        ->where_gte('last_seen', date('Y-m-d H:i:s', time() - 300)) // Last 5 minutes
        ->limit(10)
        ->find_many();
    
    if (count($recentSessions) > 0) {
        echo "\n=== Recent Session Data (Last 5 minutes) ===\n";
        foreach ($recentSessions as $s) {
            $ip_info = $s->ip_address ? " IP: {$s->ip_address}" : " IP: N/A";
            $mac_info = $s->mac_address ? " MAC: {$s->mac_address}" : " MAC: N/A";
            echo "  {$s->username} ({$s->interface}){$ip_info}{$mac_info} | RX: " . formatUsageBytes($s->session_rx) . " TX: " . formatUsageBytes($s->session_tx) . "\n";
        }
    } else {
        echo "\n=== No recent sessions found in last 5 minutes ===\n";
    }
} catch (Exception $e) {
    echo "Error displaying session data: " . $e->getMessage() . "\n";
    }

// --- GLOBAL CLEANUP: Remove sessions from disabled routers ---
if (!empty($enabled_router_ids)) {
    try {
        $disabled_sessions = ORM::for_table('tbl_usage_sessions')
            ->where_not_in('router_id', $enabled_router_ids)
            ->find_many();        $disabled_count = count($disabled_sessions);
        if ($disabled_count > 0) {
            foreach ($disabled_sessions as $disabled_session) {
                $disabled_session->delete();
            }
            echo "Cleaned {$disabled_count} sessions from disabled routers\n";
        }
    } catch (Exception $e) {
        echo "Error cleaning disabled router sessions: " . $e->getMessage() . "\n";
    }
} else {
    echo "No enabled routers found for cleanup\n";
}

echo "=== MikroTik Usage Monitor Finished ===\n";

foreach ($d as $ds) {
    try {
        $date_now = strtotime(date("Y-m-d H:i:s"));
        $expiration = strtotime($ds['expiration'] . ' ' . $ds['time']);
        echo $ds['expiration'] . " : " . ($isCli ? $ds['username'] : Lang::maskText($ds['username']));

        if ($date_now >= $expiration) {
            echo " : EXPIRED \r\n";

            // Fetch user recharge details
            $u = ORM::for_table('tbl_user_recharges')->where('id', $ds['id'])->find_one();
            if (!$u) {
                throw new Exception("User recharge record not found for ID: " . $ds['id']);
            }

            // Fetch customer details
            $c = ORM::for_table('tbl_customers')->where('id', $ds['customer_id'])->find_one();
            if (!$c) {
                $c = $u;
            }

            // Fetch plan details
            $p = ORM::for_table('tbl_plans')->where('id', $u['plan_id'])->find_one();
            if (!$p) {
                throw new Exception("Plan not found for ID: " . $u['plan_id']);
            }

            $dvc = Package::getDevice($p);
            if ($_app_stage != 'demo') {
                if (file_exists($dvc)) {
                    require_once $dvc;
                    (new $p['device'])->remove_customer($c, $p);
                } else {
                    throw new Exception("Cron error: Devices " . $p['device'] . "not found, cannot disconnect ".$c['username']."\n");
                }
            }

            // Send notification and update user status
            try {
                echo Message::sendPackageNotification(
                    $c,
                    $u['namebp'],
                    $p['price'],
                    Message::getMessageType($p['type'], $textExpired),
                    $config['user_notification_expired']
                ) . "\n";
                $u->status = 'off';
                $u->save();
            } catch (Throwable $e) {
                _log($e->getMessage());
                sendTelegram($e->getMessage());
                echo "Error: " . $e->getMessage() . "\n";
            }

            // Auto-renewal from deposit
            if ($config['enable_balance'] == 'yes' && $c['auto_renewal']) {
                [$bills, $add_cost] = User::getBills($ds['customer_id']);
                if ($add_cost != 0) {
                    $p['price'] += $add_cost;
                }

                if ($p && $c['balance'] >= $p['price']) {
                    if (Package::rechargeUser($ds['customer_id'], $ds['routers'], $p['id'], 'Customer', 'Balance')) {
                        Balance::min($ds['customer_id'], $p['price']);
                        echo "plan enabled: " . (string) $p['enabled'] . " | User balance: " . (string) $c['balance'] . " | price " . (string) $p['price'] . "\n";
                        echo "auto renewal Success\n";
                    } else {
                        echo "plan enabled: " . $p['enabled'] . " | User balance: " . $c['balance'] . " | price " . $p['price'] . "\n";
                        echo "auto renewal Failed\n";
                        Message::sendTelegram("FAILED RENEWAL #cron\n\n#u." . $c['username'] . " #buy #Hotspot \n" . $p['name_plan'] .
                            "\nRouter: " . $p['routers'] .
                            "\nPrice: " . $p['price']);
                    }
                } else {
                    echo "no renewal | plan enabled: " . (string) $p['enabled'] . " | User balance: " . (string) $c['balance'] . " | price " . (string) $p['price'] . "\n";
                }
            } else {
                echo "no renewal | balance" . $config['enable_balance'] . " auto_renewal " . $c['auto_renewal'] . "\n";
            }
        } else {
            echo " : ACTIVE \r\n";
        }
    } catch (Throwable $e) {
        // Catch any unexpected errors
        _log($e->getMessage());
        sendTelegram($e->getMessage());
        echo "Unexpected Error: " . $e->getMessage() . "\n";
    }
}

//Cek interim-update radiusrest
if ($config['frrest_interim_update'] != 0) {

    $r_a = ORM::for_table('rad_acct')
        ->whereRaw("BINARY acctstatustype = 'Start' OR acctstatustype = 'Interim-Update'")
        ->where_lte('dateAdded', date("Y-m-d H:i:s"))->find_many();

    foreach ($r_a as $ra) {
        $interval = $_c['frrest_interim_update'] * 60;
        $timeUpdate = strtotime($ra['dateAdded']) + $interval;
        $timeNow = strtotime(date("Y-m-d H:i:s"));
        if ($timeNow >= $timeUpdate) {
            $ra->acctstatustype = 'Stop';
            $ra->save();
        }
    }
}

if ($config['router_check']) {
    echo "Checking router status...\n";
    $routers = ORM::for_table('tbl_routers')->where('enabled', '1')->find_many();
    if (!$routers) {
        echo "No active routers found in the database.\n";
        flock($lock, LOCK_UN);
        fclose($lock);
        unlink($lockFile);
        exit;
    }

    $offlineRouters = [];
    $errors = [];

    foreach ($routers as $router) {
        // check if custom port
        if (strpos($router->ip_address, ':') === false) {
            $ip = $router->ip_address;
            $port = 8728;
        } else {
            [$ip, $port] = explode(':', $router->ip_address);
        }
        $isOnline = false;

        try {
            $timeout = 5;
            if (is_callable('fsockopen') && false === stripos(ini_get('disable_functions'), 'fsockopen')) {
                $fsock = @fsockopen($ip, $port, $errno, $errstr, $timeout);
                if ($fsock) {
                    fclose($fsock);
                    $isOnline = true;
                } else {
                    throw new Exception("Unable to connect to $ip on port $port using fsockopen: $errstr ($errno)");
                }
            } elseif (is_callable('stream_socket_client') && false === stripos(ini_get('disable_functions'), 'stream_socket_client')) {
                $connection = @stream_socket_client("$ip:$port", $errno, $errstr, $timeout);
                if ($connection) {
                    fclose($connection);
                    $isOnline = true;
                } else {
                    throw new Exception("Unable to connect to $ip on port $port using stream_socket_client: $errstr ($errno)");
                }
            } else {
                throw new Exception("Neither fsockopen nor stream_socket_client are enabled on the server.");
            }
        } catch (Exception $e) {
            _log($e->getMessage());
            $errors[] = "Error with router $ip: " . $e->getMessage();
        }

        if ($isOnline) {
            $router->last_seen = date('Y-m-d H:i:s');
            $router->status = 'Online';
        } else {
            $router->status = 'Offline';
            $offlineRouters[] = $router;
        }

        $router->save();
    }
    
    if (!empty($offlineRouters)) {
        $message = "Dear Administrator,\n";
        $message .= "The following routers are offline:\n";
        foreach ($offlineRouters as $router) {
            $message .= "Name: {$router->name}, IP: {$router->ip_address}, Last Seen: {$router->last_seen}\n";
        }
        $message .= "\nPlease check the router's status and take appropriate action.\n\nBest regards,\nRouter Monitoring System";

        $adminEmail = $config['mail_from'];
        $subject = "Router Offline Alert";
        Message::SendEmail($adminEmail, $subject, $message);
        sendTelegram($message);
    }

    if (!empty($errors)) {
        $message = "The following errors occurred during router monitoring:\n";
        foreach ($errors as $error) {
            $message .= "$error\n";
        }

        $adminEmail = $config['mail_from'];
        $subject = "Router Monitoring Error Alert";
        Message::SendEmail($adminEmail, $subject, $message);
        sendTelegram($message);
    }
    echo "Router monitoring finished checking.\n";
}

// Clean old dashboard cache files (JSON files older than 10 minutes)
$cache_cleaned = 0;
if (is_dir($CACHE_PATH)) {
    $json_files = glob($CACHE_PATH . '/*.json');
    foreach ($json_files as $file) {
        if (file_exists($file) && (time() - filemtime($file)) > 600) { // 10 minutes
            if (unlink($file)) {
                $cache_cleaned++;
            }
        }
    }
    if ($cache_cleaned > 0) {
        echo "Cleaned $cache_cleaned old dashboard cache files.\n";
    }
}

flock($lock, LOCK_UN);
fclose($lock);
unlink($lockFile);

$timestampFile = "$UPLOAD_PATH/cron_last_run.txt";
file_put_contents($timestampFile, time());

run_hook('cronjob_end'); #HOOK
echo "Cron job finished and completed successfully.\n";