<?php
/* Smarty version 4.5.3, created on 2025-10-06 22:01:36
  from '/var/www/html/loy/ui/ui/admin/transactions/list.tpl' */

/* @var Smarty_Internal_Template $_smarty_tpl */
if ($_smarty_tpl->_decodeProperties($_smarty_tpl, array (
  'version' => '4.5.3',
  'unifunc' => 'content_68e412106ac506_48851092',
  'has_nocache_code' => false,
  'file_dependency' => 
  array (
    '381c6cdaaeccb438b4f988bdea83624421edce9f' => 
    array (
      0 => '/var/www/html/loy/ui/ui/admin/transactions/list.tpl',
      1 => 1758268889,
      2 => 'file',
    ),
  ),
  'includes' => 
  array (
    'file:sections/header.tpl' => 1,
    'file:pagination.tpl' => 1,
    'file:sections/footer.tpl' => 1,
  ),
),false)) {
function content_68e412106ac506_48851092 (Smarty_Internal_Template $_smarty_tpl) {
$_smarty_tpl->_checkPlugins(array(0=>array('file'=>'/var/www/html/loy/system/vendor/smarty/smarty/libs/plugins/modifier.date_format.php','function'=>'smarty_modifier_date_format',),));
$_smarty_tpl->_subTemplateRender("file:sections/header.tpl", $_smarty_tpl->cache_id, $_smarty_tpl->compile_id, 0, $_smarty_tpl->cache_lifetime, array(), 0, false);
?>

<!-- Essential Statistics Only -->
<div class="row">
    <?php if (in_array($_smarty_tpl->tpl_vars['_admin']->value['user_type'],array('SuperAdmin'))) {?>
        <div class="col-lg-3 col-xs-6">
            <div class="small-box" style="background: #2c5aa0; color: white;">
                <div class="inner">
                    <h3 style="color: white;"><?php echo Lang::moneyFormat($_smarty_tpl->tpl_vars['stats']->value['total_amount']);?>
</h3>
                    <p style="color: white;">Online Payments Revenue</p>
                </div>
                <div class="icon">
                    <i class="ion ion-card" style="color: rgba(255,255,255,0.8); font-size: 50px;"></i>
                </div>
                <a href="<?php echo Text::url('reports/by-period');?>
" class="small-box-footer" style="background: rgba(0,0,0,0.1); color: white;">View Details</a>
            </div>
        </div>
        <div class="col-lg-3 col-xs-6">
            <div class="small-box" style="background: #2c5aa0; color: white;">
                <div class="inner">
                    <h3 style="color: white;"><?php echo $_smarty_tpl->tpl_vars['stats']->value['paid'];?>
</h3>
                    <p style="color: white;">Paid Online Transactions</p>
                </div>
                <div class="icon">
                    <i class="ion ion-checkmark-circled" style="color: rgba(255,255,255,0.8); font-size: 50px;"></i>
                </div>
                <a href="#" class="small-box-footer" style="background: rgba(0,0,0,0.1); color: white;">More Info</a>
            </div>
        </div>
        <div class="col-lg-3 col-xs-6">
            <div class="small-box" style="background: #2c5aa0; color: white;">
                <div class="inner">
                    <h3 style="color: white;"><?php echo Lang::moneyFormat($_smarty_tpl->tpl_vars['cash_stats']->value['total_amount']);?>
</h3>
                    <p style="color: white;">Manual Cash Revenue</p>
                </div>
                <div class="icon">
                    <i class="ion ion-cash" style="color: rgba(255,255,255,0.8); font-size: 50px;"></i>
                </div>
                <a href="<?php echo Text::url('reports/by-period');?>
" class="small-box-footer" style="background: rgba(0,0,0,0.1); color: white;">View Details</a>
            </div>
        </div>
        <div class="col-lg-3 col-xs-6">
            <div class="small-box" style="background: #2c5aa0; color: white;">
                <div class="inner">
                    <h3 style="color: white;"><?php echo $_smarty_tpl->tpl_vars['voucher_stats']->value['total_count'];?>
</h3>
                    <p style="color: white;">Voucher Recharges</p>
                </div>
                <div class="icon">
                    <i class="ion ion-pricetag" style="color: rgba(255,255,255,0.8); font-size: 50px;"></i>
                </div>
                <a href="#" class="small-box-footer" style="background: rgba(0,0,0,0.1); color: white;">More Info</a>
            </div>
        </div>
    <?php } else { ?>
        <div class="col-lg-12">
            <div class="alert alert-info">
                <i class="fa fa-info-circle"></i> Payment statistics are only visible to Super Administrators.
            </div>
        </div>
    <?php }?>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="panel panel-hovered mb20 panel-primary">
            <div class="panel-heading">
                <div class="panel-title">
                    All Payment Gateway Transactions 
                    <small class="text-muted">
                        (<?php if ($_smarty_tpl->tpl_vars['period']->value == 'previous') {?>Previous Period<?php } else { ?>Current Period<?php }?>: 
                        <?php echo smarty_modifier_date_format($_smarty_tpl->tpl_vars['period_start']->value,"%d %b %Y");?>
 - <?php echo smarty_modifier_date_format($_smarty_tpl->tpl_vars['period_end']->value,"%d %b %Y");?>
)
                    </small>
                </div>
                <div class="panel-tools">
                    <span class="label label-success">Online +</span>
                    <span class="label label-info">Cash =</span>
                    <span class="label label-primary">Total Sales: <?php echo Lang::moneyFormat($_smarty_tpl->tpl_vars['stats']->value['total_amount']+$_smarty_tpl->tpl_vars['cash_stats']->value['total_amount']);?>
</span>
                </div>
            </div>
            <div class="panel-body">
                <!-- Period Selector -->
                <div class="row mb15">
                    <div class="col-md-12">
                        <div class="btn-group" role="group" aria-label="Period Selection">
                            <a href="?_route=transactions&period=current" class="btn <?php if ($_smarty_tpl->tpl_vars['period']->value == 'current') {?>btn-primary<?php } else { ?>btn-default<?php }?>">
                                <i class="fa fa-calendar"></i> Current Period
                                <small>(<?php echo smarty_modifier_date_format($_smarty_tpl->tpl_vars['period_start']->value,"%d %b");?>
 - <?php echo smarty_modifier_date_format($_smarty_tpl->tpl_vars['period_end']->value,"%d %b");?>
)</small>
                            </a>
                            <a href="?_route=transactions&period=previous" class="btn <?php if ($_smarty_tpl->tpl_vars['period']->value == 'previous') {?>btn-primary<?php } else { ?>btn-default<?php }?>">
                                <i class="fa fa-history"></i> Previous Period
                            </a>
                        </div>
                        <div class="pull-right">
                            <small class="text-muted">
                                <i class="fa fa-info-circle"></i> 
                                Billing cycle resets on day <?php echo $_smarty_tpl->tpl_vars['reset_day']->value;?>
 of each month
                            </small>
                        </div>
                    </div>
                </div>
                
                <!-- Filters -->
                <div class="row mb15">
                    <div class="col-md-12">
                        <div class="form-inline" id="filterForm">
                            <div class="form-group col-xs-12 col-sm-6 col-md-3">
                                <label class="sr-only" for="q">Search</label>
                                <input type="text" name="q" id="q" class="form-control" placeholder="Search by username, transaction ID, plan..." value="<?php echo $_smarty_tpl->tpl_vars['q']->value;?>
" style="width: 100%;">
                            </div>
                            <div class="form-group col-xs-6 col-sm-3 col-md-2">
                                <label class="sr-only" for="gateway">Gateway</label>
                                <select name="gateway" id="gateway" class="form-control" style="width: 100%;">
                                    <option value="">All Gateways</option>
                                    <?php
$_from = $_smarty_tpl->smarty->ext->_foreach->init($_smarty_tpl, $_smarty_tpl->tpl_vars['gateways']->value, 'gw');
$_smarty_tpl->tpl_vars['gw']->do_else = true;
if ($_from !== null) foreach ($_from as $_smarty_tpl->tpl_vars['gw']->value) {
$_smarty_tpl->tpl_vars['gw']->do_else = false;
?>
                                        <option value="<?php echo $_smarty_tpl->tpl_vars['gw']->value['gateway'];?>
" <?php if ($_smarty_tpl->tpl_vars['gateway']->value == $_smarty_tpl->tpl_vars['gw']->value['gateway']) {?>selected<?php }?>><?php echo ucwords($_smarty_tpl->tpl_vars['gw']->value['gateway']);?>
</option>
                                    <?php
}
$_smarty_tpl->smarty->ext->_foreach->restore($_smarty_tpl, 1);?>
                                </select>
                            </div>
                            <div class="form-group col-xs-6 col-sm-3 col-md-2">
                                <label class="sr-only" for="status">Status</label>
                                <select name="status" id="status" class="form-control" style="width: 100%;">
                                    <option value="">All Status</option>
                                    <option value="1" <?php if ($_smarty_tpl->tpl_vars['status']->value == '1') {?>selected<?php }?>>Pending</option>
                                    <option value="2" <?php if ($_smarty_tpl->tpl_vars['status']->value == '2') {?>selected<?php }?>>Paid</option>
                                    <option value="3" <?php if ($_smarty_tpl->tpl_vars['status']->value == '3') {?>selected<?php }?>>Failed</option>
                                    <option value="4" <?php if ($_smarty_tpl->tpl_vars['status']->value == '4') {?>selected<?php }?>>Canceled</option>
                                </select>
                            </div>
                            <div class="form-group col-xs-6 col-sm-6 col-md-2">
                                <label class="sr-only" for="date_from">From Date</label>
                                <input type="date" name="date_from" id="date_from" class="form-control" value="<?php echo $_smarty_tpl->tpl_vars['date_from']->value;?>
" placeholder="From Date" style="width: 100%;">
                            </div>
                            <div class="form-group col-xs-6 col-sm-6 col-md-2">
                                <label class="sr-only" for="date_to">To Date</label>
                                <input type="date" name="date_to" id="date_to" class="form-control" value="<?php echo $_smarty_tpl->tpl_vars['date_to']->value;?>
" placeholder="To Date" style="width: 100%;">
                            </div>
                            <div class="form-group col-xs-12 col-sm-12 col-md-1">
                                <button type="button" id="clearFilters" class="btn btn-default" style="width: 100%;">
                                    <i class="fa fa-refresh"></i> Clear
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transactions Table -->
                <div class="table-responsive">
                    <table class="table table-bordered table-striped table-condensed">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Gateway</th>
                                <th>Transaction ID</th>
                                <th>Username</th>
                                <th>Plan</th>
                                <th>Router</th>
                                <th>Amount</th>
                                <th>Payment Method</th>
                                <th>Channel</th>
                                <th>Created</th>
                                <th>Paid</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody id="transactionsTableBody">
                            <?php
$_from = $_smarty_tpl->smarty->ext->_foreach->init($_smarty_tpl, $_smarty_tpl->tpl_vars['pgs']->value, 'pg');
$_smarty_tpl->tpl_vars['pg']->do_else = true;
if ($_from !== null) foreach ($_from as $_smarty_tpl->tpl_vars['pg']->value) {
$_smarty_tpl->tpl_vars['pg']->do_else = false;
?>
                                <tr class="<?php if ($_smarty_tpl->tpl_vars['pg']->value['status'] == 1) {?>warning<?php } elseif ($_smarty_tpl->tpl_vars['pg']->value['status'] == 2) {?>success<?php } elseif ($_smarty_tpl->tpl_vars['pg']->value['status'] == 3) {?>danger<?php } else { ?>active<?php }?>">
                                    <td>
                                        <strong>#<?php echo $_smarty_tpl->tpl_vars['pg']->value['id'];?>
</strong>
                                    </td>
                                    <td>
                                        <span class="label label-info"><?php echo ucwords($_smarty_tpl->tpl_vars['pg']->value['gateway']);?>
</span>
                                    </td>
                                    <td>
                                        <small class="text-muted"><?php if ($_smarty_tpl->tpl_vars['pg']->value['gateway_trx_id']) {
echo $_smarty_tpl->tpl_vars['pg']->value['gateway_trx_id'];
} else { ?>-<?php }?></small>
                                    </td>
                                    <td>
                                        <a href="<?php echo $_smarty_tpl->tpl_vars['_url']->value;?>
customers/viewu/<?php echo $_smarty_tpl->tpl_vars['pg']->value['username'];?>
" class="text-dark">
                                            <?php echo $_smarty_tpl->tpl_vars['pg']->value['username'];?>

                                        </a>
                                    </td>
                                    <td>
                                        <small><?php echo $_smarty_tpl->tpl_vars['pg']->value['plan_name'];?>
</small>
                                    </td>
                                    <td>
                                        <small class="text-muted"><?php echo $_smarty_tpl->tpl_vars['pg']->value['routers'];?>
</small>
                                    </td>
                                    <td>
                                        <strong><?php echo Lang::moneyFormat($_smarty_tpl->tpl_vars['pg']->value['price']);?>
</strong>
                                    </td>
                                    <td>
                                        <small><?php echo $_smarty_tpl->tpl_vars['pg']->value['payment_method'];?>
</small>
                                    </td>
                                    <td>
                                        <small class="text-muted"><?php echo $_smarty_tpl->tpl_vars['pg']->value['payment_channel'];?>
</small>
                                    </td>
                                    <td>
                                        <small><?php if ($_smarty_tpl->tpl_vars['pg']->value['created_date']) {
echo Lang::dateTimeFormat($_smarty_tpl->tpl_vars['pg']->value['created_date']);
} else { ?>-<?php }?></small>
                                    </td>
                                    <td>
                                        <small><?php if ($_smarty_tpl->tpl_vars['pg']->value['paid_date']) {
echo Lang::dateTimeFormat($_smarty_tpl->tpl_vars['pg']->value['paid_date']);
} else { ?>-<?php }?></small>
                                    </td>
                                    <td>
                                        <?php if ($_smarty_tpl->tpl_vars['pg']->value['status'] == 1) {?>
                                            <span class="label label-warning">PENDING</span>
                                        <?php } elseif ($_smarty_tpl->tpl_vars['pg']->value['status'] == 2) {?>
                                            <span class="label label-success">PAID</span>
                                        <?php } elseif ($_smarty_tpl->tpl_vars['pg']->value['status'] == 3) {?>
                                            <span class="label label-danger">FAILED</span>
                                        <?php } else { ?>
                                            <span class="label label-default">CANCELED</span>
                                        <?php }?>
                                    </td>
                                </tr>
                            <?php
}
$_smarty_tpl->smarty->ext->_foreach->restore($_smarty_tpl, 1);?>
                        </tbody>
                    </table>
                </div>

                <?php if (!$_smarty_tpl->tpl_vars['pgs']->value) {?>
                    <div class="text-center">
                        <p class="text-muted">No transactions found matching your criteria.</p>
                    </div>
                <?php }?>

                <?php $_smarty_tpl->_subTemplateRender("file:pagination.tpl", $_smarty_tpl->cache_id, $_smarty_tpl->compile_id, 0, $_smarty_tpl->cache_lifetime, array(), 0, false);
?>
            </div>
        </div>
    </div>
</div>

<!-- Ensure jQuery is loaded -->
<?php echo '<script'; ?>
 src="https://code.jquery.com/jquery-3.6.0.min.js"><?php echo '</script'; ?>
>

<!-- Custom CSS for responsive filters and period selector -->
<style>
.btn-group .btn {
    border-radius: 0;
}

.btn-group .btn:first-child {
    border-top-left-radius: 4px;
    border-bottom-left-radius: 4px;
}

.btn-group .btn:last-child {
    border-top-right-radius: 4px;
    border-bottom-right-radius: 4px;
}

@media (max-width: 768px) {
    #filterForm .form-group {
        margin-bottom: 10px;
    }
    
    #filterForm {
        display: block !important;
    }
    
    .btn-group {
        display: block;
        margin-bottom: 15px;
    }
    
    .btn-group .btn {
        display: block;
        width: 100%;
        border-radius: 4px !important;
        margin-bottom: 5px;
    }
    
    .table-responsive {
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
    }
    
    .table th, .table td {
        white-space: nowrap;
        font-size: 12px;
    }
}

@media (max-width: 576px) {
    .form-group.col-xs-12 {
        padding-left: 0;
        padding-right: 0;
    }
    
    .form-group.col-xs-6 {
        padding-left: 5px;
        padding-right: 5px;
    }
}
</style>

<?php echo '<script'; ?>
>
// Wait for jQuery to load and then execute our code
(function() {
    function initializeTransactionsPage() {
        if (typeof jQuery === 'undefined') {
            setTimeout(initializeTransactionsPage, 100);
            return;
        }
        
        var $ = jQuery; // Use jQuery explicitly
        
        $(document).ready(function() {
            let filterTimeout;
            
            // Function to perform AJAX search
            function performSearch() {
                const formData = {
                    ajax: '1',
                    q: $('#q').val(),
                    gateway: $('#gateway').val(),
                    status: $('#status').val(),
                    date_from: $('#date_from').val(),
                    date_to: $('#date_to').val(),
                    period: '<?php echo $_smarty_tpl->tpl_vars['period']->value;?>
'
                };
                
                // Show loading indicator
                $('#transactionsTableBody').html('<tr><td colspan="12" class="text-center"><i class="fa fa-spinner fa-spin"></i> Loading...</td></tr>');
                
                // Use the current page URL with parameters
                const ajaxUrl = window.location.href.split('?')[0] + '?_route=transactions';
                
                $.ajax({
                    url: ajaxUrl,
                    type: 'GET',
                    data: formData,
                    dataType: 'json',
                    success: function(data) {
                        updateTransactionsTable(data);
                    },
                    error: function(xhr, status, error) {
                        $('#transactionsTableBody').html('<tr><td colspan="12" class="text-center text-danger">Error loading transactions: ' + error + '</td></tr>');
                    }
                });
            }
            
            // Function to update the transactions table
            function updateTransactionsTable(transactions) {
        let html = '';
        
        if (transactions.length === 0) {
            html = '<tr><td colspan="12" class="text-center text-muted">No transactions found matching your criteria.</td></tr>';
        } else {
            transactions.forEach(function(pg) {
                let statusClass = '';
                let statusLabel = '';
                let statusBadge = '';
                
                switch(pg.status.toString()) {
                    case '1':
                        statusClass = 'warning';
                        statusLabel = 'PENDING';
                        statusBadge = 'label-warning';
                        break;
                    case '2':
                        statusClass = 'success';
                        statusLabel = 'PAID';
                        statusBadge = 'label-success';
                        break;
                    case '3':
                        statusClass = 'danger';
                        statusLabel = 'FAILED';
                        statusBadge = 'label-danger';
                        break;
                    default:
                        statusClass = 'active';
                        statusLabel = 'CANCELED';
                        statusBadge = 'label-default';
                }
                
                const createdDate = pg.created_date ? new Date(pg.created_date).toLocaleString() : '-';
                const paidDate = pg.paid_date ? new Date(pg.paid_date).toLocaleString() : '-';
                
                html += 
                    '<tr class="' + statusClass + '">' +
                        '<td><strong>#' + pg.id + '</strong></td>' +
                        '<td><span class="label label-info">' + pg.gateway.charAt(0).toUpperCase() + pg.gateway.slice(1) + '</span></td>' +
                        '<td><small class="text-muted">' + (pg.gateway_trx_id || '-') + '</small></td>' +
                        '<td><a href="<?php echo $_smarty_tpl->tpl_vars['_url']->value;?>
customers/viewu/' + pg.username + '" class="text-dark">' + pg.username + '</a></td>' +
                        '<td><small>' + pg.plan_name + '</small></td>' +
                        '<td><small class="text-muted">' + pg.routers + '</small></td>' +
                        '<td><strong><?php echo $_smarty_tpl->tpl_vars['_c']->value['currency_code'];?>
 ' + parseFloat(pg.price).toFixed(2) + '</strong></td>' +
                        '<td><small>' + pg.payment_method + '</small></td>' +
                        '<td><small class="text-muted">' + pg.payment_channel + '</small></td>' +
                        '<td><small>' + createdDate + '</small></td>' +
                        '<td><small>' + paidDate + '</small></td>' +
                        '<td><span class="label ' + statusBadge + '">' + statusLabel + '</span></td>' +
                    '</tr>';
            });
        }
        
                $('#transactionsTableBody').html(html);
            }
            
            // Instant search on text input
            $('#q').on('input', function() {
                clearTimeout(filterTimeout);
                filterTimeout = setTimeout(performSearch, 300); // 300ms delay for performance
            });
            
            // Instant filter on dropdown changes
            $('#gateway, #status').on('change', performSearch);
            
            // Date filter
            $('#date_from, #date_to').on('change', performSearch);
            
            // Clear filters
            $('#clearFilters').on('click', function() {
                $('#q').val('');
                $('#gateway').val('');
                $('#status').val('');
                $('#date_from').val('');
                $('#date_to').val('');
                performSearch();
            });
            
        }); // End of $(document).ready()
        
    } // End of initializeTransactionsPage()
    
    // Start the initialization
    initializeTransactionsPage();
})(); // End of self-executing function
<?php echo '</script'; ?>
><?php $_smarty_tpl->_subTemplateRender("file:sections/footer.tpl", $_smarty_tpl->cache_id, $_smarty_tpl->compile_id, 0, $_smarty_tpl->cache_lifetime, array(), 0, false);
}
}
