<?php
/* Smarty version 4.5.3, created on 2025-10-03 18:17:21
  from '/var/www/html/loy/ui/ui/widget/graph_monthly_registered_customers.tpl' */

/* @var Smarty_Internal_Template $_smarty_tpl */
if ($_smarty_tpl->_decodeProperties($_smarty_tpl, array (
  'version' => '4.5.3',
  'unifunc' => 'content_68dfe90104fce8_52860123',
  'has_nocache_code' => false,
  'file_dependency' => 
  array (
    'b6d75928432a421b28e251add38baaa2e430c4ef' => 
    array (
      0 => '/var/www/html/loy/ui/ui/widget/graph_monthly_registered_customers.tpl',
      1 => 1758268777,
      2 => 'file',
    ),
  ),
  'includes' => 
  array (
  ),
),false)) {
function content_68dfe90104fce8_52860123 (Smarty_Internal_Template $_smarty_tpl) {
?><div class="box box-solid">
    <div class="box-header with-border">
        <i class="fa fa-line-chart"></i>
        <h3 class="box-title"><?php echo Lang::T('Monthly Registered Customers');?>
</h3>
        <div class="box-tools pull-right">
            <button type="button" class="btn bg-teal btn-sm" data-widget="collapse">
                <i class="fa fa-minus"></i>
            </button>
            <a href="<?php echo Text::url('dashboard&refresh');?>
" class="btn bg-teal btn-sm">
                <i class="fa fa-refresh"></i>
            </a>
        </div>
    </div>
    <div class="box-body">
        <div class="chart-container" style="position: relative; height: 250px; width: 100%;">
            <canvas id="monthlyCustomersChart"></canvas>
        </div>
        <div class="chart-legend mt-3">
            <div class="row text-center">
                <div class="col-md-4">
                    <div class="description-block">
                        <h5 class="description-header text-green" id="totalThisYear">0</h5>
                        <span class="description-text">This Year</span>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="description-block">
                        <h5 class="description-header text-blue" id="thisMonth">0</h5>
                        <span class="description-text">This Month</span>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="description-block">
                        <h5 class="description-header text-yellow" id="avgMonth">0</h5>
                        <span class="description-text">Avg/Month</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Load Chart.js if not already loaded -->
<?php echo '<script'; ?>
 src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.js"><?php echo '</script'; ?>
>

<?php echo '<script'; ?>
 type="text/javascript">

document.addEventListener("DOMContentLoaded", function() {
    // Chart data from PHP
    var monthlyData = <?php echo json_encode($_smarty_tpl->tpl_vars['monthlyRegistered']->value);?>
;
    
    console.log('Monthly data:', monthlyData); // Debug log
    
    var monthNames = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
    var labels = [];
    var data = [];
    var currentMonth = new Date().getMonth() + 1;
    
    // Prepare data for all 12 months
    for (var i = 1; i <= 12; i++) {
        labels.push(monthNames[i - 1]);
        var monthData = monthlyData.find(function(item) {
            return parseInt(item.date) === i;
        });
        data.push(monthData ? parseInt(monthData.count) : 0);
    }
    
    console.log('Chart labels:', labels); // Debug log
    console.log('Chart data:', data); // Debug log
    
    // Calculate statistics
    var totalThisYear = data.reduce(function(a, b) { return a + b; }, 0);
    var thisMonthCount = data[currentMonth - 1] || 0;
    var avgPerMonth = totalThisYear > 0 ? Math.round(totalThisYear / 12) : 0;
    
    // Update statistics display
    document.getElementById('totalThisYear').textContent = totalThisYear;
    document.getElementById('thisMonth').textContent = thisMonthCount;
    document.getElementById('avgMonth').textContent = avgPerMonth;
    
    // Get canvas context
    var ctx = document.getElementById('monthlyCustomersChart');
    if (!ctx) {
        console.error('Canvas element not found!');
        return;
    }
    
    // Create gradient
    var gradient = ctx.getContext('2d').createLinearGradient(0, 0, 0, 250);
    gradient.addColorStop(0, 'rgba(54, 162, 235, 0.8)');
    gradient.addColorStop(1, 'rgba(54, 162, 235, 0.2)');
    
    // Create chart
    var chart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: labels,
            datasets: [{
                label: 'New Customers',
                data: data,
                backgroundColor: gradient,
                borderColor: 'rgba(54, 162, 235, 1)',
                borderWidth: 2,
                borderRadius: 4,
                borderSkipped: false
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    display: false
                },
                tooltip: {
                    backgroundColor: 'rgba(0, 0, 0, 0.8)',
                    titleColor: '#fff',
                    bodyColor: '#fff',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1,
                    callbacks: {
                        label: function(context) {
                            return 'New Customers: ' + context.parsed.y;
                        }
                    }
                }
            },
            scales: {
                x: {
                    grid: {
                        display: false
                    },
                    ticks: {
                        color: '#666',
                        font: {
                            size: 11
                        }
                    }
                },
                y: {
                    beginAtZero: true,
                    grid: {
                        color: 'rgba(0, 0, 0, 0.1)',
                        drawBorder: false
                    },
                    ticks: {
                        color: '#666',
                        font: {
                            size: 11
                        },
                        callback: function(value) {
                            return Number.isInteger(value) ? value : '';
                        }
                    }
                }
            },
            animation: {
                duration: 1000,
                easing: 'easeOutQuart'
            },
            interaction: {
                intersect: false,
                mode: 'index'
            }
        }
    });
    
    // Highlight current month
    if (chart.data.datasets[0].backgroundColor instanceof Array === false) {
        chart.data.datasets[0].backgroundColor = new Array(12).fill(gradient);
    }
    chart.data.datasets[0].backgroundColor[currentMonth - 1] = 'rgba(255, 193, 7, 0.8)';
    chart.update();
});

<?php echo '</script'; ?>
>

<style>
.chart-container {
    position: relative;
}
.description-block {
    margin: 10px 0;
}
.description-header {
    font-size: 18px;
    font-weight: bold;
    margin: 0;
}
.description-text {
    font-size: 12px;
    color: #666;
    text-transform: uppercase;
}
.text-green { color: #00a65a !important; }
.text-blue { color: #3c8dbc !important; }
.text-yellow { color: #f39c12 !important; }
</style><?php }
}
