{include file="sections/header.tpl"}
<style>
    .panel-title {
        font-weight: bolder;
        font-size: large;
    }
</style>

<form class="form-horizontal" method="post" role="form" action="{Text::url('')}settings/app-post"
    enctype="multipart/form-data">
    <input type="hidden" name="csrf_token" value="{$csrf_token}">
    <div class="panel" id="accordion" role="tablist" aria-multiselectable="true">
        <div class="panel-heading" role="tab" id="General">
            <h3 class="panel-title">
                <a role="button" data-toggle="collapse" data-parent="#accordion" href="#collapseGeneral"
                    aria-expanded="true" aria-controls="collapseGeneral">
                    {Lang::T('General')}
                </a>
            </h3>
        </div>
        <div id="collapseGeneral" class="panel-collapse collapse" role="tabpanel" aria-labelledby="headingOne">
            <div class="panel-body">
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Application Name / Company Name')}</label>
                    <div class="col-md-5">
                        <input type="text" class="form-control" id="CompanyName" name="CompanyName"
                            value="{$_c['CompanyName']}">
                    </div>
                    <span class="help-block col-md-4">{Lang::T('This Name will be shown on the Title')}</span>
                </div>
                <!-- Company Logo upload hidden for users -->
                <!-- <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Company Logo')}</label>
                    <div class="col-md-5">
                        <input type="file" class="form-control" id="logo" name="logo" accept="image/*">
                        <span
                            class="help-block">{Lang::T('For PDF Reports | Best size 1078 x 200 | uploaded image will be autosize')}</span>
                    </div>
                    <span class="help-block col-md-4">
                        <a href="./{$logo}" target="_blank"><img src="./{$logo}" height="48" alt="logo for PDF"></a>
                    </span>
                </div> -->
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Company Footer')}</label>
                    <div class="col-md-5">
                        <input type="text" class="form-control" id="CompanyFooter" name="CompanyFooter"
                            value="{$_c['CompanyFooter']}">
                    </div>
                    <span class="help-block col-md-4">{Lang::T('Will show below user pages')}</span>
                </div>

                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Phone Number')}</label>
                    <div class="col-md-5">
                        <input type="text" class="form-control" id="phone" name="phone" value="{$_c['phone']}">
                    </div>
                </div>





                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Income reset date')}</label>
                    <div class="col-md-5">
                        <select name="reset_day" id="reset_day" class="form-control">
                            {for $day=1 to 31}
                                <option value="{$day}" {if $_c['reset_day'] eq $day}selected="selected"{/if}>
                                    Day {$day}
                                </option>
                            {/for}
                        </select>
                    </div>
                    <span class="help-block col-md-4">{Lang::T('Income automatically resets on this day of every month')}</span>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Dashboard Structure')}</label>
                    <div class="col-md-5">
                        <input type="text" name="dashboard_cr" class="form-control" value="{$_c['dashboard_cr']}"
                            placeholder="12.7,5.12">
                    </div>
                    <p class="help-block col-md-4">
                        <a href="{$app_url}/docs/#Dashboard%20Structure"
                            target="_blank">{Lang::T('Read documentation')}</a>
                    </p>
                </div>
                <!-- Pretty URL display hidden for users -->
                <!-- <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Pretty URL')}</label>
                    <div class="col-md-5">
                        <input type="hidden" name="url_canonical" value="yes">
                        <div class="form-control-static"><strong>Enabled</strong> - Using clean URL structure</div>
                        <p class="help-block">
                            URLs use clean structure: <b>/settings/app?foo=bar</b>
                        </p>
                    </div>
                    <span class="help-block col-md-4">{Lang::T('Ensure .htaccess file is properly configured')}</span>
                </div> -->
                <button class="btn btn-success btn-block" name="general" type="submit">
                    {Lang::T('Save Changes')}
                </button>
            </div>

        </div>
    </div>

    <!-- Localization Section -->
    <div class="panel" id="accordion" role="tablist" aria-multiselectable="true">
        <div class="panel-heading" role="tab" id="Localization">
            <h3 class="panel-title">
                <a role="button" data-toggle="collapse" data-parent="#accordion" href="#collapseLocalization"
                    aria-expanded="false" aria-controls="collapseLocalization">
                    {Lang::T('Localization')}
                </a>
            </h3>
        </div>
        <div id="collapseLocalization" class="panel-collapse collapse" role="tabpanel" aria-labelledby="Localization">
            <div class="panel-body">
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Timezone')}</label>
                    <div class="col-md-5">
                        <select name="timezone" id="timezone" class="form-control">
                            {foreach $tlist as $value => $label}
                                <option value="{$value}" {if $_c['timezone'] eq $value}selected="selected" {/if}>
                                    {$label}</option>
                            {/foreach}
                        </select>
                    </div>
                    <p class="help-block col-md-4">Select your local timezone</p>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Date Format')}</label>
                    <div class="col-md-5">
                        <select class="form-control" name="date_format" id="date_format">
                            <option value="d/m/Y" {if $_c['date_format'] eq 'd/m/Y'} selected="selected" {/if}>
                                DD/MM/YYYY (31/12/2025)</option>
                            <option value="d.m.Y" {if $_c['date_format'] eq 'd.m.Y'} selected="selected" {/if}>
                                DD.MM.YYYY (31.12.2025)</option>
                            <option value="d-m-Y" {if $_c['date_format'] eq 'd-m-Y'} selected="selected" {/if}>
                                DD-MM-YYYY (31-12-2025)</option>
                            <option value="m/d/Y" {if $_c['date_format'] eq 'm/d/Y'} selected="selected" {/if}>
                                MM/DD/YYYY (12/31/2025)</option>
                            <option value="Y/m/d" {if $_c['date_format'] eq 'Y/m/d'} selected="selected" {/if}>
                                YYYY/MM/DD (2025/12/31)</option>
                            <option value="Y-m-d" {if $_c['date_format'] eq 'Y-m-d'} selected="selected" {/if}>
                                YYYY-MM-DD (2025-12-31)</option>
                            <option value="M d Y" {if $_c['date_format'] eq 'M d Y'} selected="selected" {/if}>
                                MMM DD YYYY (Dec 31 2025)</option>
                            <option value="d M Y" {if $_c['date_format'] eq 'd M Y'} selected="selected" {/if}>
                                DD MMM YYYY (31 Dec 2025)</option>
                            <option value="jS M y" {if $_c['date_format'] eq 'jS M y'} selected="selected" {/if}>
                                DD MMM YY (31st Dec 25)</option>
                        </select>
                    </div>
                    <p class="help-block col-md-4">Choose how dates are displayed</p>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Default Language')}</label>
                    <div class="col-md-5">
                        <select class="form-control" name="language" id="language">
                            {foreach $lani as $lanis}
                                <option value="{$lanis@key}" {if $_c['language'] eq $lanis@key} selected="selected"
                                    {/if}>
                                    {$lanis@key}
                                </option>
                            {/foreach}
                            <option disabled>_________</option>
                            {foreach $lan as $lans}
                                <option value="{$lans@key}" {if $_c['language'] eq $lans@key} selected="selected" {/if}>
                                    {$lans@key}
                                </option>
                            {/foreach}
                        </select>
                    </div>
                    <div class="col-md-4 help-block">
                        <a href="{Text::url('')}settings/language">{Lang::T('Language Editor')}</a>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Currency Code')}</label>
                    <div class="col-md-5">
                        <input type="text" class="form-control" id="currency_code" name="currency_code"
                            value="{$_c['currency_code']}" placeholder="USD, EUR, KSH">
                    </div>
                    <span class="help-block col-md-4">{Lang::T('Keep it blank if you do not want to show currency code')}</span>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Country Code Phone')}</label>
                    <div class="col-md-5">
                        <div class="input-group">
                            <span class="input-group-addon" id="basic-addon1">+</span>
                            <input type="text" class="form-control" id="country_code_phone" placeholder="254"
                                name="country_code_phone" value="{$_c['country_code_phone']}">
                        </div>
                    </div>
                    <span class="help-block col-md-4">{Lang::T('Kenya country code is 254')}</span>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Number Format')}</label>
                    <div class="col-md-5">
                        <select class="form-control" name="number_format" id="number_format">
                            <option value="1234.56" {if !$_c['dec_point'] || $_c['dec_point'] eq '.'}selected{/if}>
                                1,234.56 (International)</option>
                            <option value="1234,56" {if $_c['dec_point'] eq ','}selected{/if}>
                                1.234,56 (European)</option>
                            <option value="1 234.56" {if $_c['thousands_sep'] eq ' '}selected{/if}>
                                1 234.56 (French)</option>
                        </select>
                        <input type="hidden" name="dec_point" value="{if $_c['dec_point']}{$_c['dec_point']}{else}.{/if}">
                        <input type="hidden" name="thousands_sep" value="{if $_c['thousands_sep']}{$_c['thousands_sep']}{else},{/if}">
                    </div>
                    <span class="help-block col-md-4">Choose how numbers are formatted</span>
                </div>
                <hr>
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Radius Package')}</label>
                    <div class="col-md-5">
                        <input type="text" class="form-control" id="radius_plan" name="radius_plan"
                            value="{if $_c['radius_plan']==''}Radius Plan{else}{$_c['radius_plan']}{/if}">
                    </div>
                    <span class="help-block col-md-4">{Lang::T('Change title in user Plan order')}</span>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Hotspot Package')}</label>
                    <div class="col-md-5">
                        <input type="text" class="form-control" id="hotspot_plan" name="hotspot_plan"
                            value="{if $_c['hotspot_plan']==''}Hotspot Plan{else}{$_c['hotspot_plan']}{/if}">
                    </div>
                    <span class="help-block col-md-4">{Lang::T('Change title in user Plan order')}</span>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('PPPOE Package')}</label>
                    <div class="col-md-5">
                        <input type="text" class="form-control" id="pppoe_plan" name="pppoe_plan"
                            value="{if $_c['pppoe_plan']==''}PPPOE Plan{else}{$_c['pppoe_plan']}{/if}">
                    </div>
                    <span class="help-block col-md-4">{Lang::T('Change title in user Plan order')}</span>
                </div>
                <button class="btn btn-success btn-block" name="localization" type="submit">
                    {Lang::T('Save Changes')}
                </button>
            </div>
        </div>
    </div>

    <div class="panel">
        <div class="panel-heading" role="tab" id="Security">
            <h4 class="panel-title">
                <a class="collapsed" role="button" data-toggle="collapse" data-parent="#accordion"
                    href="#collapseSecurity" aria-expanded="false" aria-controls="collapseSecurity">
                    {Lang::T('Security')}
                </a>
            </h4>
        </div>
        <div id="collapseSecurity" class="panel-collapse collapse" role="tabpanel">
            <div class="panel-body">
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Enable Session Timeout')}</label>
                    <div class="col-md-5">
                        <label class="switch">
                            <input type="checkbox" id="enable_session_timeout" value="1" name="enable_session_timeout"
                                {if $_c['enable_session_timeout']==1}checked{/if}>
                            <span class="slider"></span>
                        </label>
                    </div>
                    <p class="help-block col-md-4">
                        {Lang::T('Logout Admin if not Available/Online a period of time')}</p>
                </div>
                <div class="form-group" id="timeout_duration_input" style="display: none;">
                    <label class="col-md-3 control-label">{Lang::T('Timeout Duration')}</label>
                    <div class="col-md-5">
                        <input type="number" value="{$_c['session_timeout_duration']}" class="form-control"
                            name="session_timeout_duration" id="session_timeout_duration"
                            placeholder="{Lang::T('Enter the session timeout duration (minutes)')}" min="1">
                    </div>
                    <p class="help-block col-md-4">{Lang::T('Idle Timeout, Logout Admin if Idle for xx
                            minutes')}
                    </p>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Single Admin Session')}</label>
                    <div class="col-md-5">
                        <select name="single_session" id="single_session" class="form-control">
                            <option value="no">
                                {Lang::T('No')}</option>
                            <option value="yes" {if $_c['single_session']=='yes' }selected="selected" {/if}>
                                {Lang::T('Yes')}
                            </option>
                        </select>
                    </div>
                    <p class="help-block col-md-4">
                        {Lang::T('Admin can only have single session login, it will logout another session')}
                    </p>
                </div>

                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Enable CSRF Validation')}</label>
                    <div class="col-md-5">
                        <select name="csrf_enabled" id="csrf_enabled" class="form-control">
                            <option value="no">
                                {Lang::T('No')}</option>
                            <option value="yes" {if $_c['csrf_enabled']=='yes' }selected="selected" {/if}>
                                {Lang::T('Yes')}
                            </option>
                        </select>
                    </div>
                    <p class="help-block col-md-4">
                        <a href="https://en.wikipedia.org/wiki/Cross-site_request_forgery"
                            target="_blank">{Lang::T('Cross-site request forgery')}</a>
                    </p>
                </div>
                <button class="btn btn-success btn-block" type="submit">
                    {Lang::T('Save Changes')}
                </button>
            </div>
        </div>
    </div>



    <div class="panel">
        <div class="panel-heading" role="tab" id="FreeRadius">
            <h4 class="panel-title">
                <a class="collapsed" role="button" data-toggle="collapse" data-parent="#accordion"
                    href="#collapseFreeRadius" aria-expanded="false" aria-controls="collapseFreeRadius">
                    FreeRadius
                </a>
            </h4>
        </div>
        <div id="collapseFreeRadius" class="panel-collapse collapse" role="tabpanel">
            <div class="panel-body">
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Enable Radius')}</label>
                    <div class="col-md-5">
                        <select name="radius_enable" id="radius_enable" class="form-control text-muted">
                            <option value="0">{Lang::T('No')}</option>
                            <option value="1" {if $_c['radius_enable']}selected="selected" {/if}>{Lang::T('Yes')}
                            </option>
                        </select>
                    </div>
                    <p class="help-block col-md-4"></p>
                </div>
                <button class="btn btn-success btn-block" type="submit">
                    {Lang::T('Save Changes')}
                </button>
            </div>
        </div>
    </div>





    <div class="panel">
        <div class="panel-heading" role="tab" id="TelegramNotification">
            <h4 class="panel-title">
                <a class="collapsed" role="button" data-toggle="collapse" data-parent="#accordion"
                    href="#collapseTelegramNotification" aria-expanded="false"
                    aria-controls="collapseTelegramNotification">
                    {Lang::T('Telegram Notification')}
                    <div class="btn-group pull-right">
                        <a class="btn btn-success btn-xs" style="color: black;" href="javascript:testTg()">Test TG</a>
                    </div>
                </a>
            </h4>
        </div>
        <div id="collapseTelegramNotification" class="panel-collapse collapse" role="tabpanel">
            <div class="panel-body">
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Telegram Bot Token')}</label>
                    <div class="col-md-5">
                        <input type="password" class="form-control" id="telegram_bot" name="telegram_bot"
                            onmouseleave="this.type = 'password'" onmouseenter="this.type = 'text'"
                            value="{$_c['telegram_bot']}" placeholder="123456:asdasgdkuasghddlashdashldhalskdklasd">
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Telegram User/Channel/Group ID')}</label>
                    <div class="col-md-5">
                        <input type="text" class="form-control" id="telegram_target_id" name="telegram_target_id"
                            value="{$_c['telegram_target_id']}" placeholder="12345678">
                    </div>
                </div>
                <small id="emailHelp" class="form-text text-muted">
                    {Lang::T('You will get Payment and Error notification')}
                </small>
                <button class="btn btn-success btn-block" type="submit">
                    {Lang::T('Save Changes')}
                </button>
            </div>
        </div>
    </div>

    <div class="panel">
        <div class="panel-heading" role="tab" id="SMSNotification">
            <h4 class="panel-title">
                <a class="collapsed" role="button" data-toggle="collapse" data-parent="#accordion"
                    href="#collapseSMSNotification" aria-expanded="false" aria-controls="collapseSMSNotification">
                    {Lang::T('SMS Notification')}
                    <div class="btn-group pull-right">
                        <a class="btn btn-success btn-xs" style="color: black;" href="javascript:testSms()">
                            {Lang::T('Test SMS')}
                        </a>
                    </div>
                </a>
            </h4>
        </div>
        <div id="collapseSMSNotification" class="panel-collapse collapse" role="tabpanel">
            <div class="panel-body">
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('SMS Gateway')}</label>
                    <div class="col-md-5">
                        <select class="form-control" id="sms_gateway_type" name="sms_gateway_type">
                            <option value="url" {if !$_c['sms_gateway_type'] || $_c['sms_gateway_type']=='url'}selected{/if}>SMS URL</option>
                            <option value="africastalking" {if $_c['sms_gateway_type']=='africastalking'}selected{/if}>Africa's Talking</option>
                            <option value="talksasa" {if $_c['sms_gateway_type']=='talksasa'}selected{/if}>TalkSasa</option>
                            <option value="umscomms" {if $_c['sms_gateway_type']=='umscomms'}selected{/if}>UMS Comms</option>
                        </select>
                    </div>
                    <p class="help-block col-md-4">Select your SMS gateway provider</p>
                </div>

                <!-- SMS URL Section -->
                <div id="sms_url_section">
                    <div class="form-group">
                        <label class="col-md-3 control-label">{Lang::T('SMS Server URL')}</label>
                        <div class="col-md-5">
                            <input type="text" class="form-control" id="sms_url" name="sms_url" value="{$_c['sms_url']}"
                                placeholder="https://domain/?param_number=[number]&param_text=[text]&secret=">
                        </div>
                        <p class="help-block col-md-4">{Lang::T('Must include')} <b>[text]</b> &amp; <b>[number]</b>,
                            {Lang::T('it will be replaced.')}
                        </p>
                    </div>
                </div>

                <!-- Africa's Talking Section -->
                <div id="africastalking_section" style="display: none;">
                    <div class="form-group">
                        <label class="col-md-3 control-label">Africa's Talking Username</label>
                        <div class="col-md-5">
                            <input type="text" class="form-control" id="africastalking_username" name="africastalking_username" 
                                value="{$_c['africastalking_username']}" placeholder="sandbox">
                        </div>
                        <p class="help-block col-md-4">Your Africa's Talking username (use 'sandbox' for testing)</p>
                    </div>
                    <div class="form-group">
                        <label class="col-md-3 control-label">Africa's Talking API Key</label>
                        <div class="col-md-5">
                            <input type="password" class="form-control" id="africastalking_api_key" name="africastalking_api_key" 
                                value="{$_c['africastalking_api_key']}" placeholder="Your API Key"
                                onmouseleave="this.type = 'password'" onmouseenter="this.type = 'text'">
                        </div>
                        <p class="help-block col-md-4">Your Africa's Talking API Key</p>
                    </div>
                    <div class="form-group">
                        <label class="col-md-3 control-label">Sender ID (Optional)</label>
                        <div class="col-md-5">
                            <input type="text" class="form-control" id="africastalking_sender_id" name="africastalking_sender_id" 
                                value="{$_c['africastalking_sender_id']}" placeholder="AFRICASTKNG">
                        </div>
                        <p class="help-block col-md-4">Custom sender ID (leave empty for default)</p>
                    </div>
                </div>

                <!-- TalkSasa Section -->
                <div id="talksasa_section" style="display: none;">
                    <div class="form-group">
                        <label class="col-md-3 control-label">TalkSasa API Key</label>
                        <div class="col-md-5">
                            <input type="password" class="form-control" id="talksasa_api_key" name="talksasa_api_key" 
                                value="{$_c['talksasa_api_key']}" placeholder="Your TalkSasa API Key"
                                onmouseleave="this.type = 'password'" onmouseenter="this.type = 'text'">
                        </div>
                        <p class="help-block col-md-4">Your TalkSasa API Key</p>
                    </div>
                    <div class="form-group">
                        <label class="col-md-3 control-label">Sender ID (Optional)</label>
                        <div class="col-md-5">
                            <input type="text" class="form-control" id="talksasa_sender_id" name="talksasa_sender_id" 
                                value="{$_c['talksasa_sender_id']}" placeholder="TALKSASA">
                        </div>
                        <p class="help-block col-md-4">Custom sender ID (leave empty for TALKSASA default)</p>
                    </div>
                </div>

                <!-- UMS Comms Section -->
                <div id="umscomms_section" style="display: none;">
                    <div class="form-group">
                        <label class="col-md-3 control-label">UMS Comms API Key</label>
                        <div class="col-md-5">
                            <input type="password" class="form-control" id="umscomms_api_key" name="umscomms_api_key" 
                                value="{$_c['umscomms_api_key']}" placeholder="Your UMS Comms API Key"
                                onmouseleave="this.type = 'password'" onmouseenter="this.type = 'text'">
                        </div>
                        <p class="help-block col-md-4">Your UMS Comms API Key</p>
                    </div>
                    <div class="form-group">
                        <label class="col-md-3 control-label">App ID</label>
                        <div class="col-md-5">
                            <input type="text" class="form-control" id="umscomms_app_id" name="umscomms_app_id" 
                                value="{$_c['umscomms_app_id']}" placeholder="Your App ID">
                        </div>
                        <p class="help-block col-md-4">Your UMS Comms App ID (default: UMSC131190)</p>
                    </div>
                    <div class="form-group">
                        <label class="col-md-3 control-label">Sender ID</label>
                        <div class="col-md-5">
                            <input type="text" class="form-control" id="umscomms_sender_id" name="umscomms_sender_id" 
                                value="{$_c['umscomms_sender_id']}" placeholder="UMS_TX">
                        </div>
                        <p class="help-block col-md-4">Your UMS Comms Sender ID (default: UMS_TX)</p>
                    </div>
                </div>

                <div class="form-group" style="display: none;">
                    <label class="col-md-3 control-label">{Lang::T('Or use Mikrotik SMS')}</label>
                    <div class="col-md-5">
                        <select class="form-control" id="router_select" onchange="selectRouter()">
                            <option value="">{Lang::T('Select Router')}</option>
                            {foreach $r as $rs}
                                <option value="{$rs['name']}" {if $rs['name']==$_c['sms_url']}selected{/if}>
                                    {$rs['name']}</option>
                            {/foreach}
                        </select>
                    </div>
                    <p class="help-block col-md-4">{Lang::T('Must include')} <b>[text]</b> &amp; <b>[number]</b>,
                        {Lang::T('it will be replaced.')}
                    </p>
                </div>
                <div class="form-group" style="display: none;">
                    <label class="col-md-3 control-label">{Lang::T('Mikrotik SMS Command')}</label>
                    <div class="col-md-5">
                        <input type="text" class="form-control" id="mikrotik_sms_command" name="mikrotik_sms_command"
                            value="{$_c['mikrotik_sms_command']}" placeholder="mikrotik_sms_command">
                    </div>
                </div>

                <button class="btn btn-success btn-block" type="submit">
                    {Lang::T('Save Changes')}
                </button>
            </div>
        </div>
    </div>

    <div class="panel">
        <div class="panel-heading" role="tab" id="WhatsappNotification">
            <h4 class="panel-title">
                <a class="collapsed" role="button" data-toggle="collapse" data-parent="#accordion"
                    href="#collapseWhatsappNotification" aria-expanded="false"
                    aria-controls="collapseWhatsappNotification">
                    {Lang::T('Whatsapp Notification')}
                    <div class="btn-group pull-right">
                        <a class="btn btn-success btn-xs" style="color: black;" href="javascript:testWa()">Test WA</a>
                    </div>
                </a>
            </h4>
        </div>
        <div id="collapseWhatsappNotification" class="panel-collapse collapse" role="tabpanel">
            <div class="panel-body">
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('WhatsApp Server URL')}</label>
                    <div class="col-md-5">
                        <input type="text" class="form-control" id="wa_url" name="wa_url" value="{$_c['wa_url']}"
                            placeholder="https://domain/?param_number=[number]&param_text=[text]&secret=">
                    </div>
                    <p class="help-block col-md-4">{Lang::T('Must include')} <b>[text]</b> &amp; <b>[number]</b>,
                        {Lang::T('it will be replaced.')}</p>
                </div>
                <small id="emailHelp" class="form-text text-muted">{Lang::T('You can use')} WhatsApp
                    {Lang::T('in here too.')}</small>
                <button class="btn btn-success btn-block" type="submit">
                    {Lang::T('Save Changes')}
                </button>
            </div>
        </div>
    </div>

    <div class="panel">
        <div class="panel-heading" role="tab" id="EmailNotification">
            <h4 class="panel-title">
                <a class="collapsed" role="button" data-toggle="collapse" data-parent="#accordion"
                    href="#collapseEmailNotification" aria-expanded="false" aria-controls="collapseEmailNotification">
                    {Lang::T('Email Notification')}
                    <div class="btn-group pull-right">
                        <a class="btn btn-success btn-xs" style="color: black;" href="javascript:testEmail()">Test
                            Email</a>
                    </div>
                </a>
            </h4>
        </div>
        <div id="collapseEmailNotification" class="panel-collapse collapse" role="tabpanel">
            <div class="panel-body">
                <div class="form-group">
                    <label class="col-md-3 control-label">Mail Port</label>
                    <div class="col-md-4">
                        <input type="text" class="form-control" id="smtp_host" name="smtp_host"
                            value="{$_c['smtp_host']}" placeholder="mail.yourdomain.com">
                    </div>
                    <div class="col-md-2">
                        <input type="number" class="form-control" id="smtp_port" name="smtp_port"
                            value="{$_c['smtp_port']}" placeholder="Usually 465 or 587">
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label">Email Account Username</label>
                    <div class="col-md-5">
                        <input type="text" class="form-control" id="smtp_user" name="smtp_user"
                            value="{$_c['smtp_user']}" placeholder="your@email.com">
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label">Email Account Password</label>
                    <div class="col-md-5">
                        <input type="password" class="form-control" id="smtp_pass" name="smtp_pass"
                            value="{$_c['smtp_pass']}" onmouseleave="this.type = 'password'"
                            onmouseenter="this.type = 'text'">
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label">Security Type</label>
                    <div class="col-md-5">
                        <select name="smtp_ssltls" id="smtp_ssltls" class="form-control">
                            <option value="" {if $_c['smtp_ssltls']=='' }selected="selected" {/if}>None (Not Secure)</option>
                            <option value="ssl" {if $_c['smtp_ssltls']=='ssl' }selected="selected" {/if}>SSL (Most common)</option>
                            <option value="tls" {if $_c['smtp_ssltls']=='tls' }selected="selected" {/if}>TLS</option>
                        </select>
                    </div>
                    <p class="help-block col-md-4">If unsure, leave as SSL or None.</p>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label">Sender Email Address</label>
                    <div class="col-md-5">
                        <input type="text" class="form-control" id="mail_from" name="mail_from"
                            value="{$_c['mail_from']}" placeholder="noreply@yourdomain.com">
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label">Reply-To Email Address</label>
                    <div class="col-md-5">
                        <input type="text" class="form-control" id="mail_reply_to" name="mail_reply_to"
                            value="{$_c['mail_reply_to']}" placeholder="support@yourdomain.com">
                    </div>
                    <p class="help-block col-md-4">
                        This is where replies from your customers will go. Leave blank to use the sender address above.
                    </p>
                </div>

                <button class="btn btn-success btn-block" type="submit">
                    {Lang::T('Save Changes')}
                </button>
            </div>
        </div>
    </div>

    <div class="panel">
        <div class="panel-heading" role="tab" id="UserNotification">
            <h4 class="panel-title">
                <a class="collapsed" role="button" data-toggle="collapse" data-parent="#accordion"
                    href="#collapseUserNotification" aria-expanded="false" aria-controls="collapseUserNotification">
                    {Lang::T('User Notification')}
                </a>
            </h4>
        </div>
        <div id="collapseUserNotification" class="panel-collapse collapse" role="tabpanel">
            <div class="panel-body">
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Expired Notification')}</label>
                    <div class="col-md-5">
                        <select name="user_notification_expired" id="user_notification_expired" class="form-control">
                            <option value="none">{Lang::T('None')}</option>
                            <option value="wa" {if $_c['user_notification_expired']=='wa' }selected="selected" {/if}>
                                {Lang::T('By WhatsApp')}</option>
                            <option value="sms" {if $_c['user_notification_expired']=='sms' }selected="selected" {/if}>
                                {Lang::T('By SMS')}</option>
                            <option value="email" {if $_c['user_notification_expired']=='email' }selected="selected"
                                {/if}>{Lang::T('By Email')}</option>
                        </select>
                    </div>
                    <p class="help-block col-md-4">{Lang::T('User will get notification when package expired')}</p>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Payment Notification')}</label>
                    <div class="col-md-5">
                        <select name="user_notification_payment" id="user_notification_payment" class="form-control">
                            <option value="none">{Lang::T('None')}</option>
                            <option value="wa" {if $_c['user_notification_payment']=='wa' }selected="selected" {/if}>
                                {Lang::T('By WhatsApp')}</option>
                            <option value="sms" {if $_c['user_notification_payment']=='sms' }selected="selected" {/if}>
                                {Lang::T('By SMS')}</option>
                            <option value="email" {if $_c['user_notification_payment']=='email' }selected="selected"
                                {/if}>{Lang::T('By Email')}</option>
                        </select>
                    </div>
                    <p class="help-block col-md-4">
                        {Lang::T('User will get invoice notification when buy package or package refilled')}</p>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Reminder Notification')}</label>
                    <div class="col-md-5">
                        <select name="user_notification_reminder" id="user_notification_reminder" class="form-control">
                            <option value="none">{Lang::T('None')}</option>
                            <option value="wa" {if $_c['user_notification_reminder']=='wa' }selected="selected" {/if}>
                                {Lang::T('By WhatsApp')}</option>
                            <option value="sms" {if $_c['user_notification_reminder']=='sms' }selected="selected" {/if}>
                                {Lang::T('By SMS')}</option>
                            <option value="sms" {if $_c['user_notification_reminder']=='email' }selected="selected"
                                {/if}>{Lang::T('By Email')}</option>
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Reminder Notify Intervals')}</label><br>
                    <label class="col-md-3 control-label">
                        <input type="checkbox" name="notification_reminder_1day" value="yes"
                            {if !isset($_c['notification_reminder_1day']) || $_c['notification_reminder_1day'] neq 'no'}checked{/if}>
                        {Lang::T('1 Day')}
                    </label>
                    <label class="col-md-3 control-label">
                        <input type="checkbox" name="notification_reminder_3days" value="yes"
                            {if !isset($_c['notification_reminder_3days']) || $_c['notification_reminder_3days'] neq 'no'}checked{/if}>
                        {Lang::T('3 Days')}
                    </label>
                    <label class="col-md-3 control-label">
                        <input type="checkbox" name="notification_reminder_7days" value="yes"
                            {if !isset($_c['notification_reminder_7days']) || $_c['notification_reminder_7days'] neq 'no'}checked{/if}>
                        {Lang::T('7 Days')}
                    </label>
                </div>
                <button class="btn btn-success btn-block" type="submit">
                    {Lang::T('Save Changes')}
                </button>
            </div>
        </div>
    </div>

    <div class="panel">
        <div class="panel-heading" role="tab" id="Miscellaneous">
            <h4 class="panel-title">
                <a class="collapsed" role="button" data-toggle="collapse" data-parent="#accordion"
                    href="#collapseMiscellaneous" aria-expanded="false" aria-controls="collapseMiscellaneous">
                    {Lang::T('Miscellaneous')}
                </a>
            </h4>
        </div>
        <div id="collapseMiscellaneous" class="panel-collapse collapse" role="tabpanel">
            <div class="panel-body">
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('New Version Notification')}</label>
                    <div class="col-md-5">
                        <select name="new_version_notify" id="new_version_notify" class="form-control">
                            <option value="enable" {if $_c['new_version_notify']=='enable' }selected="selected"
                                {/if}>
                                {Lang::T('Enabled')}
                            </option>
                            <option value="disable" {if $_c['new_version_notify']=='disable' }selected="selected"
                                {/if}>
                                {Lang::T('Disabled')}
                            </option>
                        </select>
                    </div>
                    <p class="help-block col-md-4"><small>
                            {Lang::T('This is to notify you when new updates is available')}</small>
                    </p>
                </div>
                
                <!-- Router Check hidden: always enabled, not shown to user -->

                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Phone OTP Required')}</label>
                    <div class="col-md-5">
                        <select name="allow_phone_otp" id="allow_phone_otp" class="form-control">
                            <option value="no" {if $_c['allow_phone_otp']=='no' }selected="selected" {/if}>
                                {Lang::T('No')}</option>
                            <option value="yes" {if $_c['allow_phone_otp']=='yes' }selected="selected" {/if}>
                                {Lang::T('Yes')}
                            </option>
                        </select>
                    </div>
                    <p class="help-block col-md-4"><small>
                            {Lang::T('OTP is required when user want to change phone number and registration')}</small>
                    </p>
                </div>
                
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('OTP Method')}</label>
                    <div class="col-md-5">
                        <select name="phone_otp_type" id="phone_otp_type" class="form-control">
                            <option value="sms" {if $_c['phone_otp_type']=='sms' }selected="selected" {/if}>
                                {Lang::T('By SMS')}
                            <option value="whatsapp" {if $_c['phone_otp_type']=='whatsapp' }selected="selected"
                                {/if}>
                                {Lang::T('by WhatsApp')}
                            <option value="both" {if $_c['phone_otp_type']=='both' }selected="selected" {/if}>
                                {Lang::T('By WhatsApp and SMS')}
                            </option>
                        </select>
                    </div>
                    <p class="help-block col-md-4"><small>{Lang::T('The method which OTP will be sent to user')}<br>
                            {Lang::T('For Registration and Update Phone Number')}</small></p>
                </div>
                
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Email OTP Required')}</label>
                    <div class="col-md-5">
                        <select name="allow_email_otp" id="allow_email_otp" class="form-control">
                            <option value="no" {if $_c['allow_email_otp']=='no' }selected="selected" {/if}>
                                {Lang::T('No')}</option>
                            <option value="yes" {if $_c['allow_email_otp']=='yes' }selected="selected" {/if}>
                                {Lang::T('Yes')}
                            </option>
                        </select>
                    </div>
                    <p class="help-block col-md-4"><small>
                            {Lang::T('OTP is required when user want to change Email Address')}
                        </small>
                    </p>
                </div>
                
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Show Bandwidth Plan')}</label>
                    <div class="col-md-5">
                        <select name="show_bandwidth_plan" id="show_bandwidth_plan" class="form-control">
                            <option value="no" {if $_c['show_bandwidth_plan']=='no' }selected="selected" {/if}>
                                {Lang::T('No')}</option>
                            <option value="yes" {if $_c['show_bandwidth_plan']=='yes' }selected="selected" {/if}>
                                {Lang::T('Yes')}</option>
                        </select>
                    </div>
                    <p class="help-block col-md-4"><small>
                            {Lang::T('Display bandwidth plan for customer')}</small></p>
                </div>
                
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Hotspot Auth Method')}</label>
                    <div class="col-md-5">
                        <select name="hs_auth_method" id="auth_method" class="form-control">
                            <option value="api" {if $_c['hs_auth_method']=='api' }selected="selected" {/if}>
                                {Lang::T('Api')}
                            </option>
                            <option value="hchap" {if $_c['hs_auth_method']=='hchap' }selected="selected" {/if}>
                                {Lang::T('Http-Chap')}
                            </option>
                        </select>
                    </div>
                    <p class="help-block col-md-4"><small>
                            {Lang::T('Hotspot Authentication Method. Make sure you have changed your hotspot login page.')}</small>
                    </p>
                </div>
                
                <div class="form-group">
                    <label class="col-md-3 control-label">{Lang::T('Radius Rest Interim-Update')}</label>
                    <div class="col-md-5">
                        <input type="number" class="form-control" id="frrest_interim_update" name="frrest_interim_update"
                            value="{if $_c['frrest_interim_update']}{$_c['frrest_interim_update']}{else}0{/if}">
                    </div>
                    <p class="help-block col-md-4"><small>
                            {Lang::T('in minutes, leave 0 to disable this feature.')}</small>
                    </p>
                </div>
                
                <!-- Check if Customer Online hidden: always enabled, not shown to user -->
                
                <!-- Extend Package Expiry hidden: always enabled, not shown to user -->
                
                <button class="btn btn-success btn-block" type="submit">
                    {Lang::T('Save Changes')}
                </button>
            </div>
        </div>
    </div>
</form>
<div class="bs-callout bs-callout-info" id="callout-navbar-role">
    <h4><b>{Lang::T('Settings For Mikrotik')}</b></h4>
    <p>/ip hotspot walled-garden <br>
        add dst-host={$_domain} <br>
        add dst-host=*.{$_domain}
    </p>
    <br>
    <h4><b>{Lang::T('Settings For Cron Expired')}</b></h4>
    <p>
        # {Lang::T('Expired Cronjob Every 5 Minutes [Recommended]')}<br>
        */1 * * * * cd {$dir} && {$php} cron.php
        <br>
    </p>
    <br>
    <h4><b>{Lang::T('Settings For Cron Reminder')}</b></h4>
    <p>
        # {Lang::T('Reminder Cronjob Every 7 AM')}<br>
        0 7 * * * cd {$dir} && {$php} cron_reminder.php
    </p>
    <br>
</div>

<script>
    function testWa() {
        var target = prompt("Phone number\nSave First before Test", "");
        if (target != null) {
            window.location.href = '{Text::url('settings/app&testWa=')}' + target;
        }
    }

    function testSms() {
        var target = prompt("Phone number\nSave First before Test", "");
        if (target != null) {
            window.location.href = '{Text::url('settings/app&testSms=')}' + target;
        }
    }


    function testEmail() {
        var target = prompt("Email\nSave First before Test", "");
        if (target != null) {
            window.location.href = '{Text::url('settings/app&testEmail=')}' + target;
        }
    }

    function testTg() {
        window.location.href = '{Text::url('settings/app&testTg=test')}';
    }

    function toggleSmsGateway() {
        var gatewayType = document.getElementById('sms_gateway_type').value;
        var smsUrlSection = document.getElementById('sms_url_section');
        var africastalkingSection = document.getElementById('africastalking_section');
        var talksasaSection = document.getElementById('talksasa_section');
        var umscommsSection = document.getElementById('umscomms_section');
        
        // Hide all sections first
        smsUrlSection.style.display = 'none';
        africastalkingSection.style.display = 'none';
        talksasaSection.style.display = 'none';
        umscommsSection.style.display = 'none';
        
        // Show the selected section
        if (gatewayType === 'africastalking') {
            africastalkingSection.style.display = 'block';
        } else if (gatewayType === 'talksasa') {
            talksasaSection.style.display = 'block';
        } else if (gatewayType === 'umscomms') {
            umscommsSection.style.display = 'block';
        } else {
            smsUrlSection.style.display = 'block';
        }
    }
    
    // Initialize on page load
    document.addEventListener('DOMContentLoaded', function() {
        toggleSmsGateway(); // Initialize sections on page load
        
        // Add event listener to the dropdown to track changes
        document.getElementById('sms_gateway_type').addEventListener('change', function() {
            toggleSmsGateway();
        });
    });
</script>


<script>
    document.addEventListener('DOMContentLoaded', function() {
        var sectionTimeoutCheckbox = document.getElementById('enable_session_timeout');
        var timeoutDurationInput = document.getElementById('timeout_duration_input');
        var timeoutDurationField = document.getElementById('session_timeout_duration');

        if (sectionTimeoutCheckbox.checked) {
            timeoutDurationInput.style.display = 'block';
            timeoutDurationField.required = true;
        }

        sectionTimeoutCheckbox.addEventListener('change', function() {
            if (this.checked) {
                timeoutDurationInput.style.display = 'block';
                timeoutDurationField.required = true;
            } else {
                timeoutDurationInput.style.display = 'none';
                timeoutDurationField.required = false;
            }
        });

        document.querySelector('form').addEventListener('submit', function(event) {
            if (sectionTimeoutCheckbox.checked && (!timeoutDurationField.value || isNaN(
                    timeoutDurationField.value))) {
                event.preventDefault();
                alert('Please enter a valid session timeout duration.');
                timeoutDurationField.focus();
            }
        });
    });
</script>

<script>
    document.addEventListener("DOMContentLoaded", function() {
        // Function to toggle visibility of custom tax rate input field
        function toggleCustomTaxRate() {
            var taxRateSelect = document.getElementById("tax_rate");
            var customTaxRateInput = document.getElementById("customTaxRate");

            if (taxRateSelect.value === "custom") {
                customTaxRateInput.style.display = "block";
            } else {
                customTaxRateInput.style.display = "none";
            }
        }

        // Call the function when the page loads
        toggleCustomTaxRate();

        // Call the function whenever the tax rate dropdown value changes
        document.getElementById("tax_rate").addEventListener("change", toggleCustomTaxRate);
    });
</script>
<script>
    document.getElementById('login_page_type').addEventListener('change', function() {
        var selectedValue = this.value;
        var customFields = document.getElementById('customFields');

        if (selectedValue === 'custom') {
            customFields.style.display = 'block';
        } else {
            customFields.style.display = 'none';
        }
    });
    document.getElementById('login_page_type').dispatchEvent(new Event('change'));
</script>

<script>
    function selectRouter() {
        var routerSelect = document.getElementById('router_select');
        var smsUrlField = document.getElementById('sms_url');
        
        if (routerSelect.value) {
            // User selected a router, confirm before overwriting SMS URL
            if (smsUrlField.value && smsUrlField.value !== routerSelect.value) {
                if (confirm('This will replace your current SMS URL with the selected router. Continue?')) {
                    smsUrlField.value = routerSelect.value;
                } else {
                    // User cancelled, reset router selection
                    routerSelect.value = '';
                }
            } else {
                // No existing SMS URL or same value, safe to set
                smsUrlField.value = routerSelect.value;
            }
        }
        // If empty selection, do nothing to SMS URL field
    }
    
    // Update router selection when SMS URL changes
    document.getElementById('sms_url').addEventListener('input', function() {
        var routerSelect = document.getElementById('router_select');
        var smsUrlValue = this.value;
        
        // Check if the current SMS URL matches any router
        var matchFound = false;
        for (var i = 0; i < routerSelect.options.length; i++) {
            if (routerSelect.options[i].value === smsUrlValue) {
                routerSelect.value = smsUrlValue;
                matchFound = true;
                break;
            }
        }
        
        // If no match found, reset router selection to "Select Router"
        if (!matchFound) {
            routerSelect.value = '';
        }
    });
    
    // Initialize timezone select2 dropdown
    $("#timezone").select2({
        placeholder: "Select timezone...",
        allowClear: false
    });
    
    // Initialize number format dropdown based on current settings
    $(document).ready(function() {
        var currentDecPoint = '{if $_c["dec_point"]}{$_c["dec_point"]}{else}.{/if}';
        var currentThousandsSep = '{if $_c["thousands_sep"]}{$_c["thousands_sep"]}{else},{/if}';
        
        if (currentDecPoint === ',' && currentThousandsSep === '.') {
            $("#number_format").val('1234,56');
        } else if (currentDecPoint === '.' && currentThousandsSep === ' ') {
            $("#number_format").val('1 234.56');
        } else {
            $("#number_format").val('1234.56');
        }
    });
    
    // Handle number format changes
    $("#number_format").change(function() {
        var format = $(this).val();
        var decPoint = '.';
        var thousandsSep = ',';
        
        if (format === '1234,56') {
            decPoint = ',';
            thousandsSep = '.';
        } else if (format === '1 234.56') {
            decPoint = '.';
            thousandsSep = ' ';
        }
        
        // Update hidden fields if they exist
        $('input[name="dec_point"]').val(decPoint);
        $('input[name="thousands_sep"]').val(thousandsSep);
    });
</script>

<!-- Joined On Information -->
<div class="row" style="margin-top: 30px;">
    <div class="col-md-12">
        <div class="pull-right text-muted">
            <small>
                <i class="fa fa-calendar"></i> 
                <strong>System Started:</strong> 
                {if $_c['system_start_date']}
                    {date('F j, Y', strtotime($_c['system_start_date']))}
                {else}
                    Not yet initialized
                {/if}
            </small>
        </div>
        <div class="clearfix"></div>
    </div>
</div>

{include file="sections/footer.tpl"}
