{include file="sections/header.tpl"}
<!-- voucher-add -->

{if !in_array($_admin['user_type'],['SuperAdmin','Admin'])}
<div class="row">
    <div class="col-sm-12">
        <div class="alert alert-danger">
            <h4><i class="fa fa-ban"></i> Access Denied!</h4>
            You do not have permission to create vouchers. Only Super Administrators and Administrators can create vouchers.
            <br><br>
            <strong>Your Role:</strong> {$_admin['user_type']}<br>
            <strong>Available Actions:</strong> View vouchers, Distribute vouchers, Print vouchers
            <br><br>
            <a href="{Text::url('')}plan/voucher" class="btn btn-primary">
                <i class="fa fa-list"></i> View Vouchers
            </a>
            <a href="{Text::url('')}plan/refill" class="btn btn-success">
                <i class="fa fa-share"></i> Distribute Vouchers
            </a>
        </div>
    </div>
</div>
{else}

<div class="row">
    <div class="col-sm-12 col-md-12">
        <div class="panel panel-primary panel-hovered panel-stacked mb30">
            <div class="panel-heading">{Lang::T('Add Vouchers')} - {$_admin['user_type']} Access</div>
            <div class="panel-body">

                <form class="form-horizontal" method="post" role="form" action="{Text::url('')}plan/voucher-post">
                    <div class="form-group">
                        <label class="col-md-2 control-label">{Lang::T('Type')}</label>
                        <div class="col-md-6">
                            <input type="radio" id="Hot" name="type" value="Hotspot">
                            <label for="Hot">{Lang::T('Hotspot Plans')}</label>
                            &nbsp;&nbsp;
                            <input type="radio" id="POE" name="type" value="PPPOE">
                            <label for="POE">{Lang::T('PPPOE Plans')}</label>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-2 control-label">{Lang::T('Routers')}</label>
                        <div class="col-md-6">
                            <select id="server" name="server" class="form-control select2">
                                <option value=''>{Lang::T('Select Routers')}</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-2 control-label">{Lang::T('Service Plan')}</label>
                        <div class="col-md-6">
                            <select id="plan" name="plan" class="form-control select2">
                                <option value=''>{Lang::T('Select Plans')}</option>
                            </select>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-2 control-label">{Lang::T('Number of Vouchers')}</label>
                        <div class="col-md-6">
                            <input type="text" class="form-control" name="numbervoucher" id="numbervoucher" value="1">
                            <small class="help-block" id="numbervoucher-help" style="display: none; color: #888;">
                                <i class="fa fa-info-circle"></i> Field disabled - voucher count determined by custom names or phone numbers
                            </small>
                        </div>
                    </div>
                    <div class="form-group">
                        <label class="col-md-2 control-label">{Lang::T('Custom Voucher Name(s)')}</label>
                        <div class="col-md-6">
                            <input type="text" class="form-control" name="custom_name" id="custom_name" 
                                   title="Enter single name or multiple names separated by commas" oninput="updateVoucherPreview()">
                        </div>
                        <p class="help-block col-md-4">Optional: Enter single name or multiple names separated by commas (e.g., "skyknot, 0712345678"). Multiple names will override voucher count and use exact name lengths.</p>
                    </div>
                    <div class="form-group" id="voucher_preview_group" style="display:none;">
                        <label class="col-md-2 control-label">Preview:</label>
                        <div class="col-md-6">
                            <div class="form-control-static" style="background: #f5f5f5; padding: 8px; border: 1px solid #ddd; border-radius: 4px;">
                                <strong id="voucher_preview">al123</strong>
                            </div>
                        </div>
                        <p class="help-block col-md-4">Example of how your voucher will look with current settings</p>
                    </div>
                    <div class="form-group">
                        <label class="col-md-2 control-label">{Lang::T('Length Code')}</label>
                        <div class="col-md-6">
                            <select class="form-control" name="lengthcode" id="lengthcode" required onchange="updateVoucherPreview()">
                                <option value="2">2 characters</option>
                                <option value="3">3 characters</option>
                                <option value="4">4 characters</option>
                                <option value="5">5 characters</option>
                                <option value="6">6 characters</option>
                                <option value="7">7 characters</option>
                                <option value="8">8 characters</option>
                                <option value="9">9 characters</option>
                                <option value="10" selected>10 characters</option>
                            </select>
                            <small class="help-block" id="lengthcode-help" style="display: none; color: #888;">
                                <i class="fa fa-info-circle"></i> Field disabled - length determined by custom names or phone numbers
                            </small>
                        </div>
                        <p class="help-block col-md-4" id="lengthcode-desc">Select voucher code length from 2 to 10 characters.</p>
                    </div>

                    <!-- SMS Options Section -->
                    <div class="form-group">
                        <label class="col-lg-2 control-label">
                            <i class="fa fa-mobile"></i> SMS Delivery
                        </label>
                        <div class="col-lg-6">
                            <div class="panel panel-info">
                                <div class="panel-body" style="padding: 20px;">
                                    <div class="checkbox" style="margin-bottom: 15px;">
                                        <label style="font-weight: 500;">
                                            <input type="checkbox" id="enable_sms" name="enable_sms" value="1">
                                            <span style="margin-left: 8px;">Send voucher(s) via SMS after creation</span>
                                        </label>
                                    </div>
                                    <div id="sms_options" style="display: none;">
                                        <div class="form-group" style="margin-bottom: 15px;">
                                            <label class="control-label" style="font-weight: 600; margin-bottom: 8px;">
                                                <i class="fa fa-users"></i> Phone Numbers
                                                <span id="phone-count-badge" class="badge badge-info" style="margin-left: 10px; display: none;">0 numbers</span>
                                            </label>
                                            <textarea class="form-control" name="sms_phones" id="sms_phones" 
                                                    placeholder="Enter phone numbers separated by commas:&#10;+254712345678, +254798765432&#10;0712345678, 0798765432&#10;712345678, 798765432&#10;&#10;Or one per line:&#10;+254712345678&#10;0798765432&#10;712345678" 
                                                    rows="4" style="padding: 12px; line-height: 1.4;"></textarea>
                                            <small class="help-block" style="margin-top: 8px; padding: 8px; background: #f8f9fa; border-radius: 4px;">
                                                <i class="fa fa-info-circle text-info"></i> 
                                                <strong>Supported formats:</strong> +254712345678, 0712345678, 712345678. 
                                                <strong>Separate with commas</strong> or new lines. Country code added automatically.
                                            </small>
                                            <div id="voucher-count-info" style="display: none; margin-top: 10px; padding: 8px; background: #e8f4fd; border-left: 4px solid #2196F3; border-radius: 4px;">
                                                <i class="fa fa-calculator text-primary"></i>
                                                <strong id="phone-count-text">0 phone numbers</strong> detected. 
                                                Voucher count will be automatically set to generate <strong id="voucher-count-text">0 vouchers</strong>.
                                            </div>
                                        </div>
                                        

                                        
                                        <!-- Hidden SMS template field -->
                                        <input type="hidden" name="sms_message" id="sms_message" value="">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <p class="help-block col-md-4" style="padding: 10px; line-height: 1.5;">When enabled, each phone number will receive a unique voucher code via SMS. Number of phone numbers must match number of vouchers.</p>
                    </div>

                    <div class="form-group">
                        <div class="col-lg-offset-2 col-lg-10">
                            <button class="btn btn-success"
                                onclick="return validateAndConfirm(this)"
                                type="submit">{Lang::T('Generate')}</button>
                        </div>
                    </div>
                </form>

            </div>
        </div>
    </div>
</div>

<!-- Voucher Details Modal -->
<div class="modal fade" id="voucherDetailsModal" tabindex="-1" role="dialog" aria-labelledby="voucherDetailsModalLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title" id="voucherDetailsModalLabel">
                    <i class="fa fa-ticket"></i> {Lang::T('Voucher Created Successfully')}
                </h4>
            </div>
            <div class="modal-body">
                <div id="voucher-loading" class="text-center" style="padding: 30px;">
                    <i class="fa fa-spinner fa-spin fa-2x"></i>
                    <p class="text-muted">Loading voucher details...</p>
                </div>
                <div id="voucher-content" style="display: none;">
                    <div class="row">
                        <div class="col-md-7">
                            <div class="panel panel-default">
                                <div class="panel-heading">
                                    <h5 class="panel-title"><i class="fa fa-ticket"></i> Voucher Details</h5>
                                </div>
                                <div class="panel-body" style="padding: 20px;">
                                    <pre id="voucher-print-content" style="background: #f8f8f8; border: 1px solid #ddd; padding: 20px; border-radius: 6px; font-size: 13px; line-height: 1.4; max-height: 400px; overflow-y: auto; font-family: 'Courier New', monospace;"></pre>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-5">
                            <div class="panel panel-success">
                                <div class="panel-heading">
                                    <h5 class="panel-title">
                                        <i class="fa fa-mobile"></i> Send Additional SMS
                                    </h5>
                                </div>
                                <div class="panel-body" style="padding: 20px;">
                                    <div class="form-group">
                                        <label for="sms-phone-add" style="font-weight: 600; margin-bottom: 10px;">
                                            <i class="fa fa-phone"></i> Phone Number
                                        </label>
                                        <div class="input-group input-group-lg">
                                            <span class="input-group-addon" id="country-code-display-add" style="padding: 12px 15px; font-weight: bold;">
                                                <i class="fa fa-flag"></i> +254
                                            </span>
                                            <input type="tel" class="form-control" id="sms-phone-add" 
                                                   placeholder="712345678" 
                                                   maxlength="9"
                                                   pattern="^[71][0-9]{8}$"
                                                   style="padding: 12px; font-size: 16px; font-weight: 500;">
                                            <span class="input-group-btn">
                                                <button type="button" class="btn btn-success btn-lg" id="send-sms-btn-add" style="padding: 12px 20px;">
                                                    <i class="fa fa-paper-plane"></i> Send
                                                </button>
                                            </span>
                                        </div>
                                        <small class="help-block" style="margin-top: 10px; padding: 8px; background: #f0f8ff; border-radius: 4px;">
                                            <i class="fa fa-info-circle text-info"></i> 
                                            Enter phone number: <strong>712345678</strong> or <strong>101234567</strong>
                                        </small>
                                    </div>
                                    
                                    <div class="alert alert-info" style="margin-top: 15px; margin-bottom: 0; font-size: 13px; padding: 15px;">
                                        <i class="fa fa-check-circle"></i> 
                                        <strong>Voucher Ready!</strong><br>
                                        Send to additional recipients or copy the voucher details above.
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" onclick="window.location.href='{Text::url('')}plan/voucher'">
                    <i class="fa fa-list"></i> View All Vouchers
                </button>
                <button type="button" class="btn btn-success" onclick="window.location.href='{Text::url('')}plan/add-voucher'">
                    <i class="fa fa-plus"></i> Create Another Voucher
                </button>
                <button type="button" class="btn btn-default" data-dismiss="modal">
                    <i class="fa fa-times"></i> Close
                </button>
            </div>
        </div>
    </div>
</div>

    <!-- /voucher-add -->

<script>
    // Radio button functionality for plan type selection
    $(document).ready(function() {
        // Initialize - Hotspot is already checked by default in HTML
        
        // No additional JavaScript needed - radio buttons work natively
        // The existing server-side JavaScript will handle the type changes
    });
</script>

<style>
    #lengthcode:focus {
        border-color: #3498db;
        box-shadow: 0 0 5px rgba(52, 152, 219, 0.5);
    }
    
    #lengthcode:invalid {
        border-color: #e74c3c;
        box-shadow: 0 0 5px rgba(231, 76, 60, 0.5);
    }
    
    .help-block {
        font-size: 12px;
        margin-top: 5px;
    }
    
    /* SMS Input Validation Styles */
    .valid-input {
        border-color: #5cb85c !important;
        box-shadow: 0 0 5px rgba(92, 184, 92, 0.5) !important;
    }
    
    .invalid-input {
        border-color: #d9534f !important;
        box-shadow: 0 0 5px rgba(217, 83, 79, 0.5) !important;
    }
    
    /* Enhanced SMS Panel Styling */
    .panel-success .panel-heading {
        background-color: #5cb85c;
        border-color: #4cae4c;
        color: white;
    }
    
    .panel-info .panel-body {
        background-color: #f8f9fa;
    }
    
    .input-group-lg .form-control {
        font-size: 16px;
        font-weight: 500;
        padding: 12px 15px;
    }
    
    .input-group-addon {
        font-weight: bold;
        background-color: #e9ecef;
        border-color: #ced4da;
    }
    
    /* Badge styling */
    .badge-success {
        background-color: #28a745;
    }
    
    .badge-info {
        background-color: #17a2b8;
    }
    
    /* Phone count info styling */
    #voucher-count-info {
        animation: slideIn 0.3s ease;
    }
    
    @keyframes slideIn {
        from { opacity: 0; transform: translateY(-10px); }
        to { opacity: 1; transform: translateY(0); }
    }
    
    /* Form spacing improvements */
    .form-group {
        margin-bottom: 20px;
    }
    
    .panel-body {
        line-height: 1.6;
    }
    
    /* Better textarea styling */
    textarea.form-control {
        resize: vertical;
        min-height: 100px;
    }
    
    /* Alert improvements */
    .alert {
        border-radius: 6px;
        border: none;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    
    /* Disabled field styling */
    .field-disabled {
        background-color: #f5f5f5 !important;
        color: #888 !important;
        cursor: not-allowed !important;
        opacity: 0.6;
    }
    
    .field-disabled-container {
        opacity: 0.6;
        pointer-events: none;
    }
</style>

<script>
    // Initialize voucher preview when page loads
    document.addEventListener('DOMContentLoaded', function() {
        // Initialize the preview with default values
        updateVoucherPreview();
    });

    // SMS options handling with automatic voucher counting
    document.addEventListener('DOMContentLoaded', function() {
        var enableSmsCheckbox = document.getElementById('enable_sms');
        var smsOptions = document.getElementById('sms_options');
        var smsPhones = document.getElementById('sms_phones');
        var numberVoucherInput = document.querySelector('input[name="numbervoucher"]');
        
        if (enableSmsCheckbox) {
            enableSmsCheckbox.addEventListener('change', function() {
                if (this.checked) {
                    smsOptions.style.display = 'block';
                    updatePhoneCount(); // Update count when enabled
                } else {
                    smsOptions.style.display = 'none';
                    // Reset voucher count to 1 when disabled
                    numberVoucherInput.value = '1';
                    hideVoucherCountInfo();
                }
            });
        }
        
        // Real-time phone number counting and voucher updating
        if (smsPhones) {
            smsPhones.addEventListener('input', function() {
                updatePhoneCount();
            });
            
            smsPhones.addEventListener('paste', function() {
                // Give paste operation time to complete
                setTimeout(function() {
                    updatePhoneCount();
                }, 100);
            });
        }
        
        // Also update phone count when custom names change (for smart matching display)
        var customNameInput = document.getElementById('custom_name');
        if (customNameInput) {
            customNameInput.addEventListener('input', function() {
                updatePhoneCount(); // Update SMS info when prefixes change
            });
        }
        

        
        function updatePhoneCount() {
            if (!enableSmsCheckbox.checked) return;
            
            var phoneText = smsPhones.value.trim();
            var phones = parsePhoneNumbers(phoneText);
            var phoneCount = phones.length;
            
            // Check if there are custom prefixes
            var customNameInput = document.getElementById('custom_name').value.trim();
            var customPrefixes = [];
            if (customNameInput) {
                var names = customNameInput.split(',');
                for (var i = 0; i < names.length; i++) {
                    var cleaned = names[i].trim().replace(/[^a-zA-Z0-9]/g, '');
                    if (cleaned.length > 0) {
                        customPrefixes.push(cleaned);
                    }
                }
            }
            
            // Update badge and count display
            var phoneBadge = document.getElementById('phone-count-badge');
            var phoneCountText = document.getElementById('phone-count-text');
            var voucherCountText = document.getElementById('voucher-count-text');
            var voucherCountInfo = document.getElementById('voucher-count-info');
            
            if (phoneCount > 0) {
                phoneBadge.style.display = 'inline';
                phoneBadge.textContent = phoneCount + ' number' + (phoneCount !== 1 ? 's' : '');
                
                // Check voucher count vs phone count for validation
                var currentVoucherCount = parseInt(numberVoucherInput.value) || 1;
                var matchingInfo = '';
                var badgeClass = 'badge badge-success';
                
                if (phoneCount !== currentVoucherCount) {
                    matchingInfo = ' (⚠️ mismatch: need ' + currentVoucherCount + ' vouchers)';
                    badgeClass = 'badge badge-warning';
                } else {
                    matchingInfo = ' (✅ matches voucher count)';
                }
                
                phoneCountText.textContent = phoneCount + ' phone number' + (phoneCount !== 1 ? 's' : '');
                voucherCountText.textContent = phoneCount + ' SMS recipient' + (phoneCount !== 1 ? 's' : '') + matchingInfo;
                voucherCountInfo.style.display = 'block';
                
                // Add visual feedback based on validation
                phoneBadge.className = badgeClass;
            } else {
                hideVoucherCountInfo();
                // Don't reset if there are custom prefixes without SMS
                if (customPrefixes.length === 0) {
                    numberVoucherInput.value = '1'; // Reset to default only if no prefixes
                }
            }
        }
        
        function hideVoucherCountInfo() {
            var phoneBadge = document.getElementById('phone-count-badge');
            var voucherCountInfo = document.getElementById('voucher-count-info');
            
            phoneBadge.style.display = 'none';
            voucherCountInfo.style.display = 'none';
            
            // Check if we should re-enable fields when SMS is disabled
            var customNameInput = document.getElementById('custom_name').value.trim();
            var customNames = [];
            if (customNameInput) {
                var names = customNameInput.split(',');
                for (var i = 0; i < names.length; i++) {
                    var cleaned = names[i].trim().replace(/[^a-zA-Z0-9]/g, '');
                    if (cleaned.length > 0) {
                        customNames.push(cleaned);
                    }
                }
            }
            // Only re-enable if no multiple custom names
            if (customNames.length <= 1) {
                enableAllFields();
            }
        }
        
        function parsePhoneNumbers(text) {
            if (!text) return [];
            
            // Split by commas and newlines, but prioritize commas
            var numbers = text.split(/[,\n\r]+/);
            var validNumbers = [];
            
            numbers.forEach(function(num) {
                num = num.trim();
                if (num) {
                    // Clean the number - remove all non-digit characters except +
                    var cleaned = num.replace(/[^0-9+]/g, '');
                    
                    // Parse different formats - support 01, 07, 2541, 2547, +254 prefixes
                    if (cleaned.match(/^\+254[0-9]{9}$/)) {
                        // +254712345678 format
                        validNumbers.push(cleaned);
                    } else if (cleaned.match(/^0[17][0-9]{8}$/)) {
                        // 0712345678, 0101234567 format - remove leading 0 and add +254
                        validNumbers.push('+254' + cleaned.substring(1));
                    } else if (cleaned.match(/^[17][0-9]{8}$/)) {
                        // 712345678, 101234567 format - add +254
                        validNumbers.push('+254' + cleaned);
                    } else if (cleaned.match(/^254[17][0-9]{8}$/)) {
                        // 254712345678, 254101234567 format - add +
                        validNumbers.push('+' + cleaned);
                    }
                }
            });
            
            // Remove duplicates
            return [...new Set(validNumbers)];
        }
    });

    function updateVoucherPreview() {
        var customNameInput = document.getElementById('custom_name').value;
        var lengthCode = parseInt(document.getElementById('lengthcode').value) || 7;
        var previewGroup = document.getElementById('voucher_preview_group');
        var previewText = document.getElementById('voucher_preview');
        var numberVoucherInput = document.querySelector('input[name="numbervoucher"]');
        
        // Check for multiple phone numbers as well
        var enableSmsCheckbox = document.getElementById('enable_sms');
        var smsPhones = document.getElementById('sms_phones');
        var phoneCount = 0;
        
        if (enableSmsCheckbox && enableSmsCheckbox.checked && smsPhones) {
            var phones = parsePhoneNumbers(smsPhones.value.trim());
            phoneCount = phones.length;
        }
        
        if (customNameInput.trim().length > 0) {
            // Check if multiple names are provided (contains comma)
            var names = customNameInput.split(',');
            var cleanedNames = [];
            
            for (var i = 0; i < names.length; i++) {
                var cleaned = names[i].trim().replace(/[^a-zA-Z0-9]/g, '');
                if (cleaned.length > 0) {
                    cleanedNames.push(cleaned);
                }
            }
            
            if (cleanedNames.length > 1) {
                // Multiple names - show maximum 2 in preview
                var previewNames = cleanedNames.slice(0, 2);
                var moreCount = cleanedNames.length - 2;
                var preview = previewNames.join(', ');
                if (moreCount > 0) {
                    preview += ' (+' + moreCount + ' more)';
                }
                preview += ' (exact names, ' + cleanedNames.length + ' vouchers)';
                previewText.textContent = preview;
                
                // Disable fields when multiple names provided
                disableFieldsForMultipleItems('custom_names');
                
                // Only auto-update voucher count if SMS is not enabled (SMS takes priority)
                if (!enableSmsCheckbox || !enableSmsCheckbox.checked) {
                    numberVoucherInput.value = cleanedNames.length;
                } else {
                    // If SMS is enabled, trigger update to show smart matching
                    updatePhoneCount();
                }
                
            } else if (cleanedNames.length == 1) {
                // Single name - use original logic
                var customName = cleanedNames[0];
                var finalVoucher = '';
                var description = '';
                
                if (customName.length >= lengthCode) {
                    finalVoucher = customName.substring(0, lengthCode);
                    description = ' (custom name only)';
                } else {
                    var remaining = lengthCode - customName.length;
                    var randomChars = '';
                    
                    var chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
                    for (var i = 0; i < remaining; i++) {
                        randomChars += chars.charAt(Math.floor(Math.random() * chars.length));
                    }
                    
                    finalVoucher = customName + randomChars;
                    description = ' (custom + ' + remaining + ' random)';
                }
                
                previewText.textContent = finalVoucher + description;
                
                // Re-enable fields for single name
                if (phoneCount <= 1) {
                    enableAllFields();
                }
            }
            
            previewGroup.style.display = 'block';
        } else {
            // No custom name - show default preview for chosen length
            var randomExample = '';
            var chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
            for (var i = 0; i < lengthCode; i++) {
                randomExample += chars.charAt(Math.floor(Math.random() * chars.length));
            }
            previewText.textContent = randomExample + ' (all random)';
            previewGroup.style.display = 'block';
            
            // Re-enable all fields (no custom names)
            enableAllFields();
        }
    }
    
    function disableFieldsForMultipleItems(type) {
        var numberVoucherInput = document.getElementById('numbervoucher');
        var lengthCodeSelect = document.getElementById('lengthcode');
        var numberVoucherHelp = document.getElementById('numbervoucher-help');
        var lengthCodeHelp = document.getElementById('lengthcode-help');
        var lengthCodeDesc = document.getElementById('lengthcode-desc');
        
        // Disable number of vouchers field
        numberVoucherInput.classList.add('field-disabled');
        numberVoucherInput.disabled = true;
        numberVoucherHelp.style.display = 'block';
        
        // Disable length code field
        lengthCodeSelect.classList.add('field-disabled');
        lengthCodeSelect.disabled = true;
        lengthCodeHelp.style.display = 'block';
        lengthCodeDesc.style.display = 'none';
    }
    
    function enableAllFields() {
        var numberVoucherInput = document.getElementById('numbervoucher');
        var lengthCodeSelect = document.getElementById('lengthcode');
        var numberVoucherHelp = document.getElementById('numbervoucher-help');
        var lengthCodeHelp = document.getElementById('lengthcode-help');
        var lengthCodeDesc = document.getElementById('lengthcode-desc');
        
        // Enable number of vouchers field
        numberVoucherInput.classList.remove('field-disabled');
        numberVoucherInput.disabled = false;
        numberVoucherHelp.style.display = 'none';
        
        // Enable length code field
        lengthCodeSelect.classList.remove('field-disabled');
        lengthCodeSelect.disabled = false;
        lengthCodeHelp.style.display = 'none';
        lengthCodeDesc.style.display = 'block';
    }

    // Voucher details modal functionality (similar to list page)
    function viewVoucherDetails(voucherId) {
        // Show modal and loading state
        $('#voucherDetailsModal').modal('show');
        $('#voucher-loading').show();
        $('#voucher-content').hide();
        
        // Make AJAX request to get voucher details
        var xhr = new XMLHttpRequest();
        xhr.open('GET', '{Text::url('')}plan/voucher-details-ajax/' + voucherId, true);
        xhr.onload = function() {
            $('#voucher-loading').hide();
            
            if (xhr.status === 200) {
                try {
                    var response = JSON.parse(xhr.responseText);
                    
                    if (response.status === 'success') {
                        // Populate modal with voucher data
                        document.getElementById('voucher-print-content').textContent = response.content;
                        
                        // Update country code display if provided
                        if (response.country_code) {
                            document.getElementById('country-code-display-add').innerHTML = '<i class="fa fa-phone"></i> +' + response.country_code;
                            window.currentCountryCode = response.country_code;
                        } else {
                            window.currentCountryCode = '254'; // Default to Kenya
                        }
                        
                        // Store voucher data for SMS sending
                        window.currentVoucherData = {
                            id: response.voucher_id,
                            content: response.content
                        };
                        
                        $('#voucher-content').show();
                    } else {
                        showErrorInModal(response.message || 'Failed to load voucher details');
                    }
                } catch (e) {
                    showErrorInModal('Invalid response from server');
                }
            } else {
                showErrorInModal('Failed to load voucher details. Please try again.');
            }
        };
        
        xhr.onerror = function() {
            $('#voucher-loading').hide();
            showErrorInModal('Network error. Please check your connection and try again.');
        };
        
        xhr.send();
    }
    
    function showErrorInModal(message) {
        $('#voucher-content').html('<div class="alert alert-danger"><i class="fa fa-exclamation-triangle"></i> ' + message + '</div>').show();
    }
    
    // SMS and modal event listeners for add page
    $(document).ready(function() {
        // SMS sending functionality
        $('#send-sms-btn-add').on('click', function() {
            var phone = $('#sms-phone-add').val().trim();
            var button = $(this);
            
            if (!phone) {
                showSMSAlert('error', 'Please enter a phone number');
                $('#sms-phone-add').focus();
                return;
            }
            
            // Validate phone number format (must start with 7 or 1 and be 9 digits)
            if (!/^[71][0-9]{8}$/.test(phone)) {
                showSMSAlert('error', 'Phone number must be 9 digits starting with 7 or 1 (e.g., 712345678)');
                $('#sms-phone-add').focus();
                return;
            }
            
            if (!window.currentVoucherData) {
                showSMSAlert('error', 'No voucher data available');
                return;
            }
            
            // Construct full phone number with country code
            var countryCode = window.currentCountryCode || '254';
            var fullPhoneNumber = '+' + countryCode + phone;
            
            // Disable button and show loading state
            button.prop('disabled', true);
            var originalHtml = button.html();
            button.html('<i class="fa fa-spinner fa-spin"></i> Sending SMS...');
            
            // Send AJAX request
            $.ajax({
                url: '{Text::url('')}plan/send-voucher-sms',
                method: 'POST',
                data: {
                    voucher_id: window.currentVoucherData.id,
                    phone: fullPhoneNumber,
                    custom_message: '' // Using default message
                },
                success: function(response) {
                    if (response.status === 'success') {
                        showSMSAlert('success', 'SMS sent successfully to +' + countryCode + phone);
                        $('#sms-phone-add').val(''); // Clear phone input
                    } else {
                        showSMSAlert('error', response.message || 'Failed to send SMS');
                    }
                },
                error: function(xhr, status, error) {
                    showSMSAlert('error', 'Network error: Unable to send SMS');
                },
                complete: function() {
                    // Re-enable button
                    button.prop('disabled', false);
                    button.html(originalHtml);
                }
            });
        });
        
        // Phone number input validation and formatting for add page
        $('#sms-phone-add').on('input', function() {
            var value = this.value;
            
            // Remove any non-digit characters
            value = value.replace(/[^0-9]/g, '');
            
            // Limit to 9 digits
            if (value.length > 9) {
                value = value.substring(0, 9);
            }
            
            // Ensure it starts with 7 or 1 if user enters something
            if (value.length > 0 && value.charAt(0) !== '7' && value.charAt(0) !== '1') {
                // If doesn't start with 7 or 1, try to correct it
                if (value.charAt(0) === '0') {
                    // Remove leading 0 and add 7 if it makes sense
                    value = '7' + value.substring(1);
                } else {
                    // Default to 7 prefix
                    value = '7' + value.substring(1);
                }
            }
            
            this.value = value;
            
            // Visual feedback for validation
            if (value.length === 9 && /^[71][0-9]{8}$/.test(value)) {
                $(this).removeClass('invalid-input').addClass('valid-input');
            } else if (value.length > 0) {
                $(this).removeClass('valid-input').addClass('invalid-input');
            } else {
                $(this).removeClass('valid-input invalid-input');
            }
        });
        
        // Allow Enter key to send SMS
        $('#sms-phone-add').on('keypress', function(e) {
            if (e.which === 13) { // Enter key
                $('#send-sms-btn-add').click();
            }
        });
        
        // Check URL parameters for auto-showing voucher details
        var urlParams = new URLSearchParams(window.location.search);
        var voucherId = urlParams.get('voucher_id');
        var showPopup = urlParams.get('show_popup');
        
        if (voucherId && showPopup === 'true') {
            // Auto-show the voucher details popup
            setTimeout(function() {
                viewVoucherDetails(voucherId);
            }, 500);
        }
    });
    
    // Function to validate form before submission
    function validateAndConfirm(button) {
        // Check required fields
        var type = document.querySelector('input[name="type"]:checked');
        var server = document.getElementById('server').value;
        var plan = document.getElementById('plan').value;
        
        var missingFields = [];
        if (!type) missingFields.push('Type (Hotspot/PPPOE)');
        if (!server) missingFields.push('Routers');
        if (!plan) missingFields.push('Service Plan');
        
        if (missingFields.length > 0) {
            alert('Please select the following required fields:\n\n• ' + missingFields.join('\n• '));
            return false;
        }
        
        // If validation passes, show confirmation
        return ask(button, '{Lang::T("Continue the Voucher creation process?")}');
    }
    
    // Function to show SMS alerts (add page version)
    function showSMSAlert(type, message) {
        var alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
        var iconClass = type === 'success' ? 'fa-check-circle' : 'fa-exclamation-triangle';
        
        var alertHtml = '<div class="alert ' + alertClass + ' alert-dismissible" role="alert">' +
                       '<button type="button" class="close" data-dismiss="alert" aria-label="Close">' +
                       '<span aria-hidden="true">&times;</span>' +
                       '</button>' +
                       '<i class="fa ' + iconClass + '"></i> ' + message +
                       '</div>';
        
        // Insert alert at the top of modal body
        $('.modal-body').prepend(alertHtml);
        
        // Auto-remove alert after 5 seconds
        setTimeout(function() {
            $('.alert').fadeOut(function() {
                $(this).remove();
            });
        }, 5000);
    }
</script>

{/if}

{include file="sections/footer.tpl"}