{include file="customer/header.tpl"}
<!-- user-activation-list -->

<div class="row">
    <div class="col-sm-12">
        <div class="panel mb20 panel-hovered panel-primary">
            <div class="panel-heading">{Lang::T('Transaction History List')}</div>
            <div class="panel-body">
                <div class="table-responsive">
                    <table id="datatable" class="table table-bordered table-striped table-condensed">
                        <thead>
                            <tr>
                                <th>{Lang::T('Invoice')}</th>
                                <th>{Lang::T('Package Name')}</th>
                                <th>{Lang::T('Package Price')}</th>
                                <th>{Lang::T('Type')}</th>
                                <th>{Lang::T('Created On')}</th>
                                <th>{Lang::T('Expires On')}</th>
                                <th>{Lang::T('Method')}</th>
                            </tr>
                        </thead>
                        <tbody>
                            {foreach $d as $ds}
                                <tr onclick="window.location.href = '{Text::url('voucher/invoice/')}{$ds.id|escape:'html'}'" style="cursor: pointer;">
                                    <td>{$ds.invoice|escape:'html'}</td>
                                    <td>{$ds.plan_name|escape:'html'}</td>
                                    <td>{Lang::moneyFormat($ds.price)}</td>
                                    <td>{$ds.type|escape:'html'}</td>
                                    <td>{Lang::dateAndTimeFormat($ds.recharged_on, $ds.recharged_time)}</td>
                                    <td>{Lang::dateAndTimeFormat($ds.expiration, $ds.time)}</td>
                                    <td>{$ds.method|escape:'html'}</td>
                                </tr>
                            {/foreach}
                        </tbody>
                    </table>
                </div>
                {include file="pagination.tpl"}
            </div>
        </div>
    </div>
</div>

{include file="customer/footer.tpl"}
