<div class="row">
    {if in_array($_admin['user_type'],['SuperAdmin','Admin', 'Report'])}
        <div class="col-lg-3 col-xs-6">
            <div class="small-box" style="background: #2c5aa0; color: white;">
                <div class="inner">
                    <h4 class="text-bold" style="font-size: large; color: white;"><sup>{$_c['currency_code']}</sup>
                        {number_format($iday,0,$_c['dec_point'],$_c['thousands_sep'])}</h4>
                </div>
                <div class="icon">
                    <i class="ion ion-clock" style="color: rgba(255,255,255,0.8);"></i>
                </div>
                <a href="{Text::url('reports/by-date')}" class="small-box-footer" style="background: rgba(0,0,0,0.1); color: white;">{Lang::T('Income Today')}</a>
            </div>
        </div>
        <div class="col-lg-3 col-xs-6">
            <div class="small-box" style="background: #2c5aa0; color: white;">
                <div class="inner">
                    <h4 class="text-bold" style="font-size: large; color: white;"><sup>{$_c['currency_code']}</sup>
                        {number_format($imonth,0,$_c['dec_point'],$_c['thousands_sep'])}</h4>
                </div>
                <div class="icon">
                    <i class="ion ion-android-calendar" style="color: rgba(255,255,255,0.8);"></i>
                </div>
                <a href="{Text::url('reports/by-period')}" class="small-box-footer" style="background: rgba(0,0,0,0.1); color: white;">{Lang::T('Income This Month')}</a>
            </div>
        </div>
    {/if}
    <div class="col-lg-3 col-xs-6">
        <div class="small-box" style="background: #2c5aa0; color: white;">
            <div class="inner">
                <h4 class="text-bold" style="font-size: large; color: white;" id="online-users-count">
                    <span id="online-count">{$u_act}</span>/<span id="inactive-count">{$u_all}</span>
                    {if $online_cached || $last_update == 0}
                        <small style="font-size: 10px; opacity: 0.7;" id="cache-indicator">
                            {if $last_update == 0}(no data){else}(cached){/if}
                        </small>
                    {/if}
                </h4>
            </div>
            <div class="icon">
                <i class="ion ion-person" style="color: rgba(255,255,255,0.8);"></i>
            </div>
            <a href="{Text::url('plan/list')}" class="small-box-footer" style="background: rgba(0,0,0,0.1); color: white;">{Lang::T('Online')}/{Lang::T('Inactive')}</a>
        </div>
    </div>

    <script>
    // Load real-time data via AJAX after page load
    $(document).ready(function() {
        // Wait a moment for the page to fully load, then fetch real data
        setTimeout(function() {
            fetchOnlineUsersData();
        }, 500);
        
        // Refresh data every 30 seconds
        setInterval(function() {
            fetchOnlineUsersData();
        }, 30000);
    });

    function fetchOnlineUsersData() {
        $.ajax({
            url: '{$_url}widgets/ajax_online_users?_=' + new Date().getTime(),
            method: 'GET',
            dataType: 'json',
            timeout: 10000, // 10 second timeout
            cache: false, // Disable caching
            success: function(data) {
                // Update the display
                $('#online-count').text(data.online || 0);
                $('#inactive-count').text(data.inactive || 0);
                
                // Update cache indicator based on data source and status
                var indicator = $('#cache-indicator');
                if (data.status && data.status !== 'live') {
                    if (indicator.length === 0) {
                        $('#online-users-count').append('<small style="font-size: 10px; opacity: 0.7;" id="cache-indicator"></small>');
                        indicator = $('#cache-indicator');
                    }
                    
                    switch(data.status) {
                        case 'error':
                            indicator.text('(database error)').css('color', '#ff0000');
                            break;
                        case 'stale':
                            indicator.text('(old data)').css('color', '#ffcc00');
                            break;
                        default:
                            indicator.text('(live data)').css('color', '#00ff00');
                    }
                } else {
                    // Live data - show green indicator or remove it
                    if (indicator.length === 0) {
                        $('#online-users-count').append('<small style="font-size: 10px; opacity: 0.7;" id="cache-indicator">(live)</small>');
                        indicator = $('#cache-indicator');
                    }
                    indicator.text('(live)').css('color', '#00ff00');
                }
            },
            error: function(xhr, status, error) {
                // On error, keep showing current values but add error indicator
                var indicator = $('#cache-indicator');
                if (indicator.length === 0) {
                    $('#online-users-count').append('<small style="font-size: 10px; opacity: 0.7;" id="cache-indicator">(connection error)</small>');
                } else {
                    indicator.text('(connection error)').css('color', '#ff0000');
                }
            }
        });
    }
    </script>
    <div class="col-lg-3 col-xs-6">
        <div class="small-box" style="background: #2c5aa0; color: white;">
            <div class="inner">
                <h4 class="text-bold" style="font-size: large; color: white;">{$c_all}</h4>
            </div>
            <div class="icon">
                <i class="ion ion-android-people" style="color: rgba(255,255,255,0.8);"></i>
            </div>
            <a href="{Text::url('customers/list')}" class="small-box-footer" style="background: rgba(0,0,0,0.1); color: white;">{Lang::T('Customers')}</a>
        </div>
    </div>
</div>